<?php
session_start();
include '../../includes/db_connection.php';

if (!isset($_SESSION['user_id']) || ($_SESSION['role'] !== 'Admin' && $_SESSION['role'] !== 'Teacher')) {
    die("You do not have permission to perform this action.");
}

$teacher_id = isset($_GET['id']) ? $_GET['id'] : null;

if ($teacher_id) {
    $sql_user = "DELETE FROM users WHERE related_id = ? AND role = 'Teacher'";
    $stmt_user = $conn->prepare($sql_user);
    $stmt_user->bind_param("i", $teacher_id);
    $stmt_user->execute();
    $stmt_user->close();
    
    $sql = "DELETE FROM teachers WHERE teacher_id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $teacher_id);

    if ($stmt->execute()) {
        header("Location: teachers_list.php");
        exit();
    } else {
        echo "Error: " . $stmt->error;
    }
    $stmt->close();
} else {
    echo "No teacher ID provided.";
}

$conn->close();
?>