<?php
session_start();
include '../../includes/db_connection.php';

// Header code (from header.php)
if (!isset($_SESSION['user_id'])) {
    header("Location: /school_management/public/index.php");
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>School Management System</title>
    <link rel="stylesheet" href="/school_management/public/css/style.css">
</head>
<body>
<div class="header">
    <h1>School Management System</h1>
    <div class="nav">
        <a href="/school_management/public/dashboard.php">Dashboard</a>
        <a href="/school_management/public/students/students_list.php">Students</a>
        <a href="/school_management/public/teachers/teachers_list.php">Teachers</a>
        <a href="/school_management/public/fees/fee_collection.php">Fees</a>
        <a href="/school_management/public/exam_results/add_exam_result.php">Exams</a>
        <a href="/school_management/public/attendance/record_attendance.php">Attendance</a>
        <a href="/school_management/public/change_password.php">Change Password</a>
        <a href="/school_management/public/logout.php">Logout</a>
    </div>
</div>
<div class="content">

<?php
if ($_SESSION['role'] !== 'Admin') {
    echo "<p style='color:red;'>You do not have permission to view this page.</p>";
    echo "</div></body></html>";
    exit();
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $first_name = $_POST['first_name'];
    $last_name = $_POST['last_name'];
    $email = $_POST['email'];
    $phone_number = $_POST['phone_number'];
    $subject = $_POST['subject'];
    $joining_date = $_POST['joining_date'];
    $class_id = $_POST['class_id']; // নতুন যুক্ত করা হয়েছে

    $sql = "INSERT INTO teachers (first_name, last_name, email, phone_number, subject, joining_date, class_id) VALUES (?, ?, ?, ?, ?, ?, ?)";
    
    $stmt = $conn->prepare($sql);
    
    if ($stmt === false) {
        die("Error in SQL query: " . $conn->error);
    }
    
    $stmt->bind_param("ssssssi", $first_name, $last_name, $email, $phone_number, $subject, $joining_date, $class_id);

    if ($stmt->execute()) {
        echo "New teacher added successfully!";
    } else {
        echo "Error: " . $stmt->error;
    }
    $stmt->close();
}

$classes_sql = "SELECT class_id, class_name FROM classes ORDER BY class_name";
$classes_result = $conn->query($classes_sql);
?>

<div class="container">
    <h2>Add New Teacher</h2>
    <form action="" method="POST">
        <label for="first_name">First Name:</label><br>
        <input type="text" id="first_name" name="first_name" required><br><br>

        <label for="last_name">Last Name:</label><br>
        <input type="text" id="last_name" name="last_name" required><br><br>

        <label for="email">Email:</label><br>
        <input type="email" id="email" name="email" required><br><br>

        <label for="phone_number">Phone Number:</label><br>
        <input type="text" id="phone_number" name="phone_number" required><br><br>

        <label for="subject">Subject:</label><br>
        <input type="text" id="subject" name="subject" required><br><br>

        <label for="joining_date">Joining Date:</label><br>
        <input type="date" id="joining_date" name="joining_date" required><br><br>

        <label for="class_id">Class:</label><br>
        <select id="class_id" name="class_id" required>
            <?php
            if ($classes_result->num_rows > 0) {
                while($row = $classes_result->fetch_assoc()) {
                    echo "<option value='" . htmlspecialchars($row['class_id']) . "'>" . htmlspecialchars($row['class_name']) . "</option>";
                }
            } else {
                echo "<option value=''>No classes found</option>";
            }
            ?>
        </select><br><br>
        
        <input type="submit" value="Add Teacher">
    </form>
</div>

<?php
$conn->close();
?>

<div class="footer">
    <p>&copy; <?php echo date("Y"); ?> School Management System. All Rights Reserved.</p>
</div>
</div>
</body>
</html>