<?php
include '../../includes/db_connection.php';

header('Content-Type: application/json');

if (isset($_GET['class_id']) && !empty($_GET['class_id'])) {
    $class_id = $_GET['class_id'];
    
    $sql = "SELECT s.subject_id, s.subject_name 
            FROM subjects s
            JOIN class_subjects cs ON s.subject_id = cs.subject_id
            WHERE cs.class_id = ?
            ORDER BY s.subject_name";
            
    $stmt = $conn->prepare($sql);
    
    if ($stmt === false) {
        echo json_encode(["error" => "SQL error: " . $conn->error]);
        exit();
    }
    
    $stmt->bind_param("i", $class_id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    $subjects = [];
    while ($row = $result->fetch_assoc()) {
        $subjects[] = $row;
    }
    
    echo json_encode($subjects);
    
    $stmt->close();
} else {
    echo json_encode([]);
}

$conn->close();
?>