<?php
session_start();
$ds = DIRECTORY_SEPARATOR;
$project_root_raw = dirname(dirname(__DIR__)); 
$project_root_1 = rtrim($project_root_raw, '/\\'); 

$db_path = $project_root_1 . $ds . 'includes' . $ds . 'db_connection.php';
$functions_path = $project_root_1 . $ds . 'includes' . $ds . 'functions.php';

if (file_exists($db_path) && file_exists($functions_path)) {
    include $db_path;
    include $functions_path;
} else {
    die("FATAL ERROR: Required core files not found.");
}

// লগইন ও অনুমতি চেক
if (!is_logged_in() || (isset($_SESSION['role']) && $_SESSION['role'] !== 'Admin')) {
    redirect_to('../../index.php'); 
}

// ডেটা লোড করার ফাংশন
function load_data($conn, $table, $id_col, $name_col) {
    $data = [];
    $sql = "SELECT {$id_col}, {$name_col} FROM {$table} ORDER BY {$id_col} ASC";
    if ($result = $conn->query($sql)) {
        while ($row = $result->fetch_assoc()) {
            $data[] = $row;
        }
        $result->free();
    } else {
         error_log("Database Query Error for table {$table}: " . $conn->error);
    }
    return $data;
}

$classes = [];
$exams = [];
$all_students_data = []; // সমস্ত ছাত্রের ডেটা PHP থেকে JavaScript-এ পাস করার জন্য

if ($conn) {
    // ১. ক্লাসের তালিকা লোড করা
    $classes = load_data($conn, 'classes', 'class_id', 'class_name');
    
    // ২. পরীক্ষার তালিকা লোড করা
    $exams = load_data($conn, 'exams', 'exam_id', 'exam_name');

    // ৩. সমস্ত ছাত্র/ছাত্রীর তালিকা লোড করা (ক্লাস আইডি সহ)
    $sql_students = "
        SELECT 
            student_id, 
            COALESCE(CONCAT(first_name, ' ', last_name), 'নাম নেই') as full_name, 
            COALESCE(class_roll, 0) as class_roll,
            class_id
        FROM 
            students 
        ORDER BY 
            class_id ASC, class_roll ASC
    ";
    
    if ($result = $conn->query($sql_students)) {
        while ($row = $result->fetch_assoc()) {
            $all_students_data[] = $row;
        }
        $result->free();
    } else {
        error_log("All Students Query Error: " . $conn->error);
    }

    // ডেটাবেস সংযোগ বন্ধ
    $conn->close();
}
?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>মার্কশিট অনুসন্ধান</title>
    <!-- স্টাইল এবং ফন্টঅসম লোড করা হচ্ছে -->
    <link rel="stylesheet" href="../../css/style.css"> 
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        body { background-color: #f0f2f5; font-family: 'Arial', sans-serif; }
        .search-container {
            max-width: 500px;
            margin: 50px auto;
            padding: 30px;
            background-color: #ffffff;
            border-radius: 12px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
        }
        h2 {
            color: #2c3e50;
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #ecf0f1;
            padding-bottom: 10px;
        }
        .form-group {
            margin-bottom: 20px;
        }
        label {
            display: block;
            margin-bottom: 8px;
            font-weight: bold;
            color: #34495e;
        }
        select, input[type="submit"] {
            width: 100%;
            padding: 12px;
            border: 1px solid #bdc3c7;
            border-radius: 8px;
            box-sizing: border-box;
            font-size: 16px;
            background-color: #ecf0f1;
            transition: border-color 0.3s;
        }
        select:focus {
            border-color: #3498db;
            outline: none;
            box-shadow: 0 0 5px rgba(52, 152, 219, 0.5);
        }
        input[type="submit"] {
            background-color: #2ecc71;
            color: white;
            cursor: pointer;
            font-weight: bold;
            border: none;
            transition: background-color 0.3s, transform 0.1s;
        }
        input[type="submit"]:hover {
            background-color: #27ae60;
        }
        input[type="submit"]:active {
            transform: translateY(1px);
        }
        #student_id:disabled {
            background-color: #dcdcdc;
            cursor: not-allowed;
        }
    </style>
</head>
<body>

<div class="search-container">
    <h2>মার্কশিট অনুসন্ধান</h2>
    
    <form action="generate_mark_sheet.php" method="GET">
        
        <!-- ১. নতুন যোগ করা হয়েছে: ক্লাস নির্বাচন -->
        <div class="form-group">
            <label for="class_id"><i class="fas fa-school"></i> শ্রেণি নির্বাচন করুন:</label>
            <select name="class_id" id="class_id" required>
                <option value="">--- শ্রেণি নির্বাচন করুন ---</option>
                <?php 
                foreach ($classes as $class) {
                    echo "<option value='{$class['class_id']}'>".htmlspecialchars($class['class_name'])."</option>";
                }
                ?>
            </select>
        </div>

        <!-- ২. শিক্ষার্থীর তালিকা (এখন এটি ক্লাস অনুযায়ী ফিল্টার হবে) -->
        <div class="form-group">
            <label for="student_id"><i class="fas fa-user-graduate"></i> শিক্ষার্থী নির্বাচন করুন:</label>
            <select name="student_id" id="student_id" required disabled>
                <option value="">--- প্রথমে শ্রেণি নির্বাচন করুন ---</option>
            </select>
        </div>

        <!-- ৩. পরীক্ষার নাম নির্বাচন -->
        <div class="form-group">
            <label for="exam_id"><i class="fas fa-file-alt"></i> পরীক্ষার নাম নির্বাচন করুন:</label>
            <select name="exam_id" id="exam_id" required>
                <option value="">--- নির্বাচন করুন ---</option>
                <?php 
                foreach ($exams as $exam) {
                    echo "<option value='{$exam['exam_id']}'>".htmlspecialchars($exam['exam_name'])."</option>";
                }
                ?>
            </select>
        </div>
        
        <!-- ক্লাস আইডি এখন সরাসরি class_id সিলেক্ট থেকে পাঠানো হবে, তাই লুকানো ইনপুটটি আর দরকার নেই -->
        <!-- <input type="hidden" name="class_id" id="hidden_class_id" value=""> -->

        <input type="submit" value="ফলাফল দেখুন">
    </form>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const classSelect = document.getElementById('class_id');
    const studentSelect = document.getElementById('student_id');
    
    // PHP থেকে লোড করা সমস্ত শিক্ষার্থীর ডেটা JavaScript এ রাখা হলো
    const allStudents = <?php echo json_encode($all_students_data); ?>;

    /**
     * নির্বাচিত ক্লাস আইডি অনুযায়ী শিক্ষার্থীদের তালিকা ফিল্টার করে ড্রপডাউনে দেখায়।
     * @param {string} classId - নির্বাচিত ক্লাসের ID
     */
    function filterAndLoadStudents(classId) {
        // ক্লাস আইডি না থাকলে, ড্রপডাউন রিসেট করুন
        if (!classId) {
            studentSelect.innerHTML = '<option value="">--- প্রথমে শ্রেণি নির্বাচন করুন ---</option>';
            studentSelect.disabled = true;
            return;
        }

        // ক্লাস আইডি অনুযায়ী শিক্ষার্থী ফিল্টার করা
        const filteredStudents = allStudents.filter(student => 
            // class_id PHP থেকে ইন্টিজার হিসেবে আসে, কিন্তু এখানে স্ট্রিং হিসেবে চেক করা নিরাপদ
            String(student.class_id) === String(classId)
        );

        let options = '<option value="">--- শিক্ষার্থী নির্বাচন করুন ---</option>';
        
        if (filteredStudents.length > 0) {
            filteredStudents.forEach(student => {
                const displayName = student.full_name.replace(/'/g, "&#39;"); // এস্কেপ সিঙ্গেল কোট
                const optionText = `আইডি: ${student.student_id} - ${displayName} (রোল: ${student.class_roll})`;
                
                // ডেটা-ক্লাস-আইডি রাখার দরকার নেই কারণ আমরা জানি এটি কোন ক্লাসের
                options += `<option value="${student.student_id}">${optionText}</option>`;
            });
            studentSelect.disabled = false;
        } else {
            options = '<option value="">এই শ্রেণিতে কোনো শিক্ষার্থী নেই</option>';
            studentSelect.disabled = true;
        }
        
        studentSelect.innerHTML = options;
    }

    // ক্লাস নির্বাচনের পরিবর্তন সনাক্ত করা
    classSelect.addEventListener('change', function() {
        filterAndLoadStudents(this.value);
    });
    
    // প্রাথমিক লোড (যদি কোনো ডিফল্ট ক্লাস সিলেক্ট করা থাকে)
    if (classSelect.value) {
        filterAndLoadStudents(classSelect.value);
    }
});
</script>

</body>
</html>
