<?php
include '../../includes/db_connection.php';

header('Content-Type: application/json');

if (isset($_GET['class_id']) && !empty($_GET['class_id'])) {
    $class_id = $_GET['class_id'];
    
    $sql = "SELECT student_id, first_name, last_name, class_roll FROM students WHERE class_id = ? ORDER BY class_roll";
    $stmt = $conn->prepare($sql);
    
    if ($stmt === false) {
        echo json_encode(["error" => "SQL error: " . $conn->error]);
        exit();
    }
    
    $stmt->bind_param("i", $class_id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    $students = [];
    while ($row = $result->fetch_assoc()) {
        $students[] = $row;
    }
    
    echo json_encode($students);
    
    $stmt->close();
} else {
    echo json_encode([]);
}

$conn->close();
?>