<?php
session_start();
include '../../includes/db_connection.php';

if (!isset($_SESSION['user_id']) || ($_SESSION['role'] !== 'Admin' && $_SESSION['role'] !== 'Teacher')) {
    die("You do not have permission to perform this action.");
}

$student_id = isset($_GET['id']) ? $_GET['id'] : null;

if ($student_id) {
    $sql_user = "DELETE FROM users WHERE related_id = ? AND role = 'Student'";
    $stmt_user = $conn->prepare($sql_user);
    $stmt_user->bind_param("i", $student_id);
    $stmt_user->execute();
    $stmt_user->close();
    
    $sql = "DELETE FROM students WHERE student_id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $student_id);

    if ($stmt->execute()) {
        header("Location: students_list.php");
        exit();
    } else {
        echo "Error: " . $stmt->error;
    }
    $stmt->close();
} else {
    echo "No student ID provided.";
}

$conn->close();
?>