<?php
session_start();
// db_connection.php ফাইলটি অন্তর্ভুক্ত করুন
include '../../includes/db_connection.php'; 

// শুধুমাত্র অ্যাডমিনকে ব্যাকআপ করার অনুমতি দিন
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'Admin') {
    die("আপনার এই ব্যাকআপ নেওয়ার অনুমতি নেই।");
}

// ------------------------------------------------------------------
// --- আপনার ডাটাবেসের নাম এখানে সেট করা হয়েছে: school_db ---
// ------------------------------------------------------------------
$db_host = 'localhost'; 
$db_user = 'root';      
$db_pass = '';          
$db_name = "school_db"; // <--- আপনার দেওয়া নাম ব্যবহার করা হয়েছে
// ------------------------------------------------------------------


// ডেটাবেস ব্যাকআপ ফাংশন
function backup_database($host, $user, $pass, $name) {
    
    $link = mysqli_connect($host, $user, $pass, $name);
    if (!$link) {
        die("ডাটাবেসের সাথে সংযোগ ব্যর্থ: " . mysqli_connect_error());
    }
    mysqli_set_charset($link, "utf8");

    $tables = array();
    $result = mysqli_query($link, 'SHOW TABLES');
    while($row = mysqli_fetch_row($result)) {
        $tables[] = $row[0];
    }

    $return = '';
    // প্রতিটি টেবিল থেকে ডেটা আনা
    foreach($tables as $table) {
        $result = mysqli_query($link, 'SELECT * FROM '.$table);
        $num_fields = mysqli_num_fields($result);
        
        // টেবিলের কাঠামো (CREATE TABLE)
        $return.= 'DROP TABLE IF EXISTS '.$table.';';
        $row2 = mysqli_fetch_row(mysqli_query($link, 'SHOW CREATE TABLE '.$table));
        $return.= "\n\n".$row2[1].";\n\n";
        
        // টেবিলের ডেটা (INSERT INTO)
        for ($i = 0; $i < $num_fields; $i++) {
            while($row = mysqli_fetch_row($result)) {
                $return.= 'INSERT INTO '.$table.' VALUES(';
                for($j=0; $j<$num_fields; $j++) {
                    $row[$j] = addslashes($row[$j]);
                    $row[$j] = preg_replace("/\n/","\\n",$row[$j]);
                    if (isset($row[$j])) { 
                        $return.= '"'.$row[$j].'"' ; 
                    } else { 
                        $return.= '""'; 
                    }
                    if ($j<($num_fields-1)) { 
                        $return.= ','; 
                    }
                }
                $return.= ");\n";
            }
        }
        $return.="\n\n\n";
    }

    // ব্যাকআপ ফাইলের নাম
    $backup_file_name = $name . '_backup_' . date('Y-m-d_H-i-s') . '.sql';

    // ফাইল ডাউনলোড করার হেডার সেট করা
    header('Content-Type: application/octet-stream');
    header("Content-Transfer-Encoding: Binary");
    header("Content-disposition: attachment; filename=\"".$backup_file_name."\"");
    
    // ডেটা আউটপুট
    echo $return;
    exit;
}

// ফাংশন কল করা
backup_database($db_host, $db_user, $db_pass, $db_name);

?>