<?php
session_start();
include '../../includes/db_connection.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: /school_management/public/index.php");
    exit();
}

$message = '';
$error = '';

// Fetch all students and classes for the dropdowns
$students_sql = "SELECT student_id, first_name, last_name, class_id FROM students ORDER BY first_name";
$students_result = $conn->query($students_sql);

$classes_sql = "SELECT class_id, class_name FROM classes ORDER BY class_name";
$classes_result = $conn->query($classes_sql);

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $student_ids = $_POST['student_ids'];
    $class_id = $_POST['class_id'];

    if (empty($student_ids)) {
        $error = "দয়া করে অন্তত একজন শিক্ষার্থী নির্বাচন করুন।";
    } else {
        $success_count = 0;
        foreach ($student_ids as $student_id) {
            // Update the student's class_id
            $sql = "UPDATE students SET class_id = ? WHERE student_id = ?";
            $stmt = $conn->prepare($sql);
            
            if ($stmt === false) {
                $error = "SQL কোয়েরি তৈরিতে সমস্যা: " . $conn->error;
                break;
            } else {
                $stmt->bind_param("ii", $class_id, $student_id);

                if ($stmt->execute()) {
                    $success_count++;
                }
                $stmt->close();
            }
        }
        if ($success_count > 0) {
            $message = $success_count . " জন শিক্ষার্থীকে সফলভাবে ক্লাসে যুক্ত করা হয়েছে!";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>শিক্ষার্থীকে ক্লাসে যুক্ত করুন</title>
    <link rel="stylesheet" href="/school_management/public/css/style.css">
    <style>
        .form-container {
            width: 500px;
            margin: 20px auto;
            background-color: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        .form-container h2 {
            text-align: center;
            color: #333;
        }
        .form-group {
            margin-bottom: 15px;
        }
        .form-group label {
            display: block;
            margin-bottom: 5px;
            font-weight: bold;
        }
        .form-group select {
            width: 100%;
            padding: 8px;
            box-sizing: border-box;
            border: 1px solid #ccc;
            border-radius: 4px;
        }
        .form-group select[multiple] {
            min-height: 150px;
        }
        .form-buttons {
            text-align: center;
            margin-top: 20px;
        }
        .form-buttons button, .form-buttons a {
            padding: 10px 20px;
            font-size: 16px;
            cursor: pointer;
            border: none;
            border-radius: 5px;
            color: white;
            background-color: #007bff;
            transition: background-color 0.3s;
            text-decoration: none;
            display: inline-block;
            margin: 0 5px;
        }
        .form-buttons button:hover, .form-buttons a:hover {
            background-color: #0056b3;
        }
        .message-success {
            color: green;
            text-align: center;
            font-weight: bold;
            margin-bottom: 10px;
        }
        .message-error {
            color: red;
            text-align: center;
            font-weight: bold;
            margin-bottom: 10px;
        }
    </style>
</head>
<body>
<div class="header">
    <h1>স্কুল ম্যানেজমেন্ট সিস্টেম</h1>
    <div class="nav">
        <a href="/school_management/public/dashboard.php">ড্যাশবোর্ড</a>
        <a href="/school_management/public/students/students_list.php">শিক্ষার্থী</a>
        <a href="/school_management/public/teachers/teachers_list.php">শিক্ষক</a>
        <a href="/school_management/public/fees/fee_collection.php">ফি</a>
        <a href="/school_management/public/fees/monthly_fee_summary.php">মাসিক রিপোর্ট</a>
        <a href="/school_management/public/exam_results/add_exam_result.php">পরীক্ষা</a>
        <a href="/school_management/public/attendance/record_attendance.php">উপস্থিতি</a>
        <a href="/school_management/public/change_password.php">পাসওয়ার্ড পরিবর্তন</a>
        <a href="/school_management/public/logout.php">লগআউট</a>
    </div>
</div>

<div class="content">
    <div class="container">
        <h2>শিক্ষার্থীকে ক্লাসে যুক্ত করুন</h2>
        <?php if ($message): ?>
            <p class="message-success"><?php echo $message; ?></p>
        <?php endif; ?>
        <?php if ($error): ?>
            <p class="message-error"><?php echo $error; ?></p>
        <?php endif; ?>
        
        <form action="" method="POST">
            <div class="form-group">
                <label for="student_ids">শিক্ষার্থী নির্বাচন করুন (একাধিক নির্বাচনের জন্য Ctrl/Command ধরে রাখুন):</label>
                <select id="student_ids" name="student_ids[]" multiple required>
                    <?php while ($row = $students_result->fetch_assoc()): ?>
                        <option value="<?php echo htmlspecialchars($row['student_id']); ?>">
                            <?php echo htmlspecialchars($row['first_name'] . ' ' . $row['last_name']); ?>
                        </option>
                    <?php endwhile; ?>
                </select>
            </div>

            <div class="form-group">
                <label for="class_id">ক্লাস নির্বাচন করুন:</label>
                <select id="class_id" name="class_id" required>
                    <option value="">--ক্লাস নির্বাচন করুন--</option>
                    <?php while ($row = $classes_result->fetch_assoc()): ?>
                        <option value="<?php echo htmlspecialchars($row['class_id']); ?>">
                            <?php echo htmlspecialchars($row['class_name']); ?>
                        </option>
                    <?php endwhile; ?>
                </select>
            </div>

            <div class="form-buttons">
                <button type="submit">যুক্ত করুন</button>
            </div>
        </form>
    </div>
</div>

<div class="footer">
    <p>&copy; <?php echo date("Y"); ?> স্কুল ম্যানেজমেন্ট সিস্টেম। সর্বস্বত্ব সংরক্ষিত।</p>
</div>

</body>
</html>