<?php
// C:\xampp\htdocs\school_management\public\routines\save_routine.php

// 1. ডেটাবেস কানেকশন অন্তর্ভুক্ত করা
// আপনার সঠিক পাথ নিশ্চিত করুন 
include '../../includes/db_connection.php'; 

// ডেটা POST মেথড দ্বারা এসেছে কিনা, তা পরীক্ষা করা হচ্ছে
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    
    // 2. ফর্ম ডেটা সংগ্রহ এবং স্যানিটাইজ করা
    // routines টেবিলের গঠন অনুযায়ী ডেটা টাইপ নিশ্চিত করা হয়েছে
    $class_id       = filter_var($_POST['class_id'], FILTER_SANITIZE_NUMBER_INT);
    $routine_type   = filter_var($_POST['routine_type'], FILTER_SANITIZE_STRING);
    // exam_id 0 বা NULL হতে পারে, তাই বিশেষ বিবেচনা করা হয়েছে
    $exam_id        = filter_var($_POST['exam_id'], FILTER_SANITIZE_NUMBER_INT);
    // যদি exam_id 0 হয়, তবে এটিকে NULL হিসেবে সেভ করার জন্য প্রস্তুত করা যেতে পারে
    $exam_id        = ($exam_id == 0) ? NULL : $exam_id;
    
    $subject_id     = filter_var($_POST['subject_id'], FILTER_SANITIZE_NUMBER_INT);
    $teacher_id     = filter_var($_POST['teacher_id'], FILTER_SANITIZE_NUMBER_INT);
    $date_or_day    = filter_var($_POST['date_or_day'], FILTER_SANITIZE_STRING);
    $start_time     = $_POST['start_time']; // 'time' ডাটা টাইপ, তাই সরাসরি নেওয়া হলো
    $end_time       = $_POST['end_time'];   // 'time' ডাটা টাইপ
    $session_type   = filter_var($_POST['session_type'], FILTER_SANITIZE_STRING);

    // 3. ডেটা যাচাই করা (সব প্রয়োজনীয় ফিল্ড আছে কি না)
    if (empty($class_id) || empty($subject_id) || empty($teacher_id) || empty($date_or_day) || empty($start_time) || empty($end_time) || empty($routine_type) || empty($session_type)) {
        // যদি কোনো গুরুত্বপূর্ণ ফিল্ড খালি থাকে
        die("Error: অনুগ্রহ করে রুটিনের সকল প্রয়োজনীয় ফিল্ড পূরণ করুন।");
    }

    // 4. SQL ক্যোয়ারি প্রস্তুত করা (Prepared Statement ব্যবহার করে)
    // routines টেবিলের কলামগুলোর ক্রম নিশ্চিত করা হয়েছে
    $sql = "INSERT INTO routines (class_id, routine_type, exam_id, subject_id, teacher_id, date_or_day, start_time, end_time, session_type) 
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";

    // কানেকশন অবজেক্ট ব্যবহার করে স্টেটমেন্ট প্রস্তুত করা
    $stmt = $conn->prepare($sql);

    if ($stmt === false) {
        // SQL ক্যোয়ারি প্রস্তুত করতে ব্যর্থ হলে
        die("Error: SQL স্টেটমেন্ট প্রস্তুতকরণে সমস্যা: " . $conn->error);
    }

    // 5. প্যারামিটারগুলো বাইন্ড করা
    // ডাটা টাইপ: i=integer, s=string. exam_id NULL হতে পারে, তাই সেটিও বিবেচনা করা হয়েছে।
    // exam_id NULL হলে 'i' (integer) বা 's' (string) এর বদলে বিশেষ টাইপ ব্যবহার না করলেও চলে, তবে bind_param এ 'i' দিতে হবে।
    $bind_type = "isiiiisss"; 
    $stmt->bind_param($bind_type, $class_id, $routine_type, $exam_id, $subject_id, $teacher_id, $date_or_day, $start_time, $end_time, $session_type);

    // 6. স্টেটমেন্ট কার্যকর করা
    if ($stmt->execute()) {
        // সেভ সফল হলে মেসেজ সহ ব্যবহারকারীকে অন্য পেজে রিডাইরেক্ট করা
        $message = "নতুন রুটিন সফলভাবে যুক্ত হয়েছে!";
        // রুটিন দেখার বা ম্যানেজ করার পেজে রিডাইরেক্ট করুন (আপনার প্রজেক্টের পাথ অনুযায়ী)
        header("Location: routine_form.php?success=" . urlencode($message)); 
        exit();
    } else {
        // কার্যকর করতে ব্যর্থ হলে
        $error_message = "রুটিন সেভ করতে ব্যর্থ: " . $stmt->error;
        die("Error: " . $error_message);
    }

    // 7. সংযোগ বন্ধ করা
    $stmt->close();
    $conn->close();

} else {
    // যদি কেউ সরাসরি এই পেজটি অ্যাক্সেস করার চেষ্টা করে
    header("Location: routine_form.php"); 
    exit();
}
?>