<?php
// C:\xampp\htdocs\school_management\public\routines\routine_grid_report.php

// 1. ডেটাবেস কানেকশন অন্তর্ভুক্ত করা
// এখানে db_connection.php এর Path নিশ্চিত করুন
include '../../includes/db_connection.php'; 

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// --- বাংলা কনভার্টার ফাংশন ---
function getBanglaDateAndDay($dateString) {
    // English to Bangla number mapping
    $en = array( '1', '2', '3', '4', '5', '6', '7', '8', '9', '0' );
    $bn = array( '১', '২', '৩', '৪', '৫', '৬', '৭', '৮', '৯', '০' );

    $dateObj = DateTime::createFromFormat('Y-m-d', $dateString);
    if (!$dateObj) {
        return ['date' => $dateString, 'day' => ''];
    }

    // Get Day in English and map to Bangla
    $day_en = $dateObj->format('l'); 
    $day_map = [
        'Saturday' => 'শনিবার', 
        'Sunday' => 'রবিবার', 
        'Monday' => 'সোমবার', 
        'Tuesday' => 'মঙ্গলবার', 
        'Wednesday' => 'বুধবার', 
        'Thursday' => 'বৃহস্পতিবার', 
        'Friday' => 'শুক্রবার'
    ];
    $day_bn = $day_map[$day_en] ?? '';

    // Format Date (e.g., 04/11/2025) and convert numbers to Bangla
    $formatted_date_en = $dateObj->format('d/m/Y');
    $formatted_date_bn = str_replace($en, $bn, $formatted_date_en);

    return ['date' => $formatted_date_bn, 'day' => $day_bn];
}

// --- পরীক্ষার ফিল্টার লজিক ---
$selected_exam_id = isset($_GET['exam_id']) ? intval($_GET['exam_id']) : 0;
$selected_class_ids = isset($_GET['class_id']) && is_array($_GET['class_id']) ? array_map('intval', $_GET['class_id']) : [];

$exams = [];
$exam_sql = "SELECT exam_id, exam_name FROM exams ORDER BY exam_id DESC";
$exam_result = $conn->query($exam_sql);
if ($exam_result && $exam_result->num_rows > 0) {
    while($row = $exam_result->fetch_assoc()) {
        $exams[$row['exam_id']] = htmlspecialchars($row['exam_name']);
    }
}

// --- ক্লাস ডেটা সংগ্রহ ---
$classes = [];
$class_sql = "SELECT class_id, class_name FROM classes ORDER BY class_id";
$class_result = $conn->query($class_sql);
if ($class_result && $class_result->num_rows > 0) {
    while($row = $class_result->fetch_assoc()) {
        $classes[$row['class_id']] = htmlspecialchars($row['class_name']);
    }
}

// --- WHERE Clause তৈরি করা ---
$where_conditions = [];
$report_title_exam = "ক্লাস ও পরীক্ষা রুটিন"; 

if ($selected_exam_id > 0) {
    if (isset($exams[$selected_exam_id])) {
        $where_conditions[] = "r.exam_id = $selected_exam_id";
        $report_title_exam = $exams[$selected_exam_id] . " রুটিন";
    } else {
        $selected_exam_id = 0;
    }
}

if (!empty($selected_class_ids)) {
    // শুধুমাত্র বৈধ এবং সংখ্যাবাচক ক্লাস আইডিগুলো ফিল্টার করা
    $valid_class_ids = array_filter($selected_class_ids, function($id) {
        return $id > 0;
    });

    if (!empty($valid_class_ids)) {
        $class_ids_list = implode(',', $valid_class_ids);
        $where_conditions[] = "r.class_id IN ($class_ids_list)";
        
        // রিপোর্টের শিরোনামে ক্লাসের নাম যোগ করা
        $class_names = array_intersect_key($classes, array_flip($valid_class_ids));
        $report_title_exam .= " (" . implode(', ', $class_names) . " এর জন্য)";
    }
}


$where_clause = "";
if (!empty($where_conditions)) {
    $where_clause = " WHERE " . implode(' AND ', $where_conditions);
}

// 2. মূল SQL ক্যোয়ারি
$sql = "SELECT 
            r.routine_type,
            r.routine_id,   
            r.exam_date,             
            r.start_time,
            r.end_time,
            r.session_type,             
            c.class_name,               
            s.subject_name,             
            e.exam_name,
            CONCAT(t.first_name, ' ', t.last_name) AS teacher_full_name 
        FROM 
            routines r
        JOIN 
            classes c ON r.class_id = c.class_id
        JOIN 
            subjects s ON r.subject_id = s.subject_id
        JOIN 
            teachers t ON r.teacher_id = t.teacher_id
        LEFT JOIN 
            exams e ON r.exam_id = e.exam_id
        " . $where_clause . " 
        ORDER BY 
            c.class_id, r.exam_date, r.start_time"; 

$result = $conn->query($sql);
if (!$result) {
    die("Error in SQL query: " . $conn->error); 
}

// 3. ডেটা Pivot করা: (Class -> Date -> Session Type) অনুসারে গ্রুপ করা হবে
$grid_data = [];
$unique_dates = [];
$unique_classes = [];
$date_session_slots = [];

if ($result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        $className = htmlspecialchars($row['class_name']);
        $examDate = htmlspecialchars($row['exam_date']);
        $sessionType = htmlspecialchars($row['session_type']);
        $startTime = date('h:i A', strtotime($row['start_time']));
        $endTime = date('h:i A', strtotime($row['end_time']));
        $subjectName = htmlspecialchars($row['subject_name']);
        
        // শিক্ষকের নাম বোল্ড ও নতুন কালার
        $teacherName = "<strong class='teacher-name'>" . htmlspecialchars($row['teacher_full_name']) . "</strong>"; 
        
        $routineType = htmlspecialchars($row['routine_type']);
        $sessionTypeKey = $sessionType; 
        
        // রুটিন কন্টেন্ট: পরীক্ষার নাম সম্পূর্ণভাবে বাদ দেওয়া হয়েছে
        $content_line = "<span class='slot-time'>(" . str_replace(['AM', 'PM'], ['সকাল', 'বিকাল'], $startTime) . " - " . str_replace(['AM', 'PM'], ['সকাল', 'বিকাল'], $endTime) . ")</span> <br>"; 
        $content_line .= "<span class='subject-name'>$subjectName</span> <br>";
        $content_line .= "<span>$teacherName</span>"; 
        
        // অনন্য তারিখ ও সেশন সংগ্রহ
        $unique_dates[$examDate] = $examDate;
        $date_session_slots[$examDate][$sessionTypeKey] = $sessionTypeKey;
        
        // প্রধান গ্রিড ডেটা তৈরি করা: Class -> Date -> Session Type -> [Array of subjects/slots]
        $grid_data[$className][$examDate][$sessionTypeKey][] = $content_line; 
        
        $unique_classes[$className] = $className;
    }
}

// 4. কলামের ক্রম অনুসারে ডেটা সাজানো (Date এবং Session Type: morning > day)
ksort($unique_dates); 
$ordered_dates = array_keys($unique_dates);
$final_columns = [];

foreach ($ordered_dates as $date) {
    if (isset($date_session_slots[$date])) {
        $date_slots = $date_session_slots[$date];
        
        $session_order_map = ['morning' => 1, 'day' => 2]; // 'day' কে 'দিবা' বা 'বিকাল' বুঝাতে ব্যবহার করা হয়েছে
        uksort($date_slots, function($a, $b) use ($session_order_map) {
            $order_a = $session_order_map[$a] ?? 3;
            $order_b = $session_order_map[$b] ?? 3;
            return $order_a <=> $order_b;
        });

        foreach ($date_slots as $sessionTypeKey) {
            $final_columns[] = [
                'date' => $date,
                'session_type' => $sessionTypeKey,
            ];
        }
    }
}

ksort($unique_classes); 
$ordered_classes = array_keys($unique_classes);
$conn->close();
?>

<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>দিনভিত্তিক গ্রিড রুটিন রিপোর্ট</title>
    
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <style>
        /* ফন্ট ও বডি স্টাইল */
        body {
            font-family: 'Arial', sans-serif; /* মানানসই ফন্ট */
            background-color: #f4f6f9;
        }

        /* প্রিন্ট-বান্ধব স্টাইল */
        @media print {
            body { font-size: 10pt; background-color: white !important; }
            .container-fluid { width: 100%; padding: 0; }
            .header-info { margin-bottom: 10px; border-bottom: 3px double #343a40; padding-bottom: 10px; }
            .table-routine th, .table-routine td { 
                padding: 4px; 
                border-color: #000 !important; 
                font-size: 9pt;
            }
            .table-routine th { 
                background-color: #e9ecef !important; 
                color: #000 !important; 
                -webkit-print-color-adjust: exact; 
                border-bottom: 1px solid #000 !important;
            }
            /* কালারফুল সেলের রঙ প্রিন্টে হালকা গ্রে হবে */
            .session-morning, .session-day { background-color: #f5f5f5 !important; -webkit-print-color-adjust: exact; }
            .class-header { background-color: #f8f9fa !important; -webkit-print-color-adjust: exact; }
            .d-print-none { display: none !important; } 
            .teacher-name { color: #000 !important; font-weight: bold; } /* প্রিন্টে গভীর নীল রঙ কালো হবে */
            .report-title { color: #000 !important; background-color: #e9ecef !important; -webkit-print-color-adjust: exact; }
        }
        
        /* মূল কন্টেইনার এবং হেডার */
        .container-fluid { padding: 30px; max-width: 1400px; }
        .header-info { text-align: center; margin-bottom: 30px; border-bottom: 3px double #343a40; padding-bottom: 15px; }
        .header-info h1 { font-size: 2.2rem; margin-bottom: 5px; color: #1e3a5f; } /* প্রতিষ্ঠানের নাম */
        .header-info p { font-size: 1rem; margin-bottom: 0; color: #555; }
        .report-title { font-size: 1.6rem; font-weight: 700; margin-top: 15px; display: inline-block; padding: 5px 15px; background-color: #1e3a5f; color: white; border-radius: 5px; }

        /* টেবিল ডিজাইন */
        .table-routine { width: 100%; border-collapse: collapse; table-layout: fixed; box-shadow: 0 4px 8px rgba(0,0,0,0.1); }
        .table-routine th, .table-routine td { border: 1px solid #ced4da; padding: 8px 4px; text-align: center; vertical-align: middle; }
        
        /* হেডার স্টাইল */
        .date-row-header { 
            background-color: #e9ecef; 
            color: #343a40; 
            font-size: 1.1em; 
            padding: 10px 4px;
            font-weight: bold;
        }
        .day-row-header { 
            background-color: #e9ecef; 
            color: #007bff; /* দিনের নাম নীল */
            font-weight: bold; 
            font-size: 0.9em; 
            padding: 5px 4px; 
            border-bottom: 2px solid #ced4da !important;
        }
        .class-header { 
            background-color: #f8f9fa; 
            font-weight: bold; 
            min-width: 120px;
            color: #1e3a5f;
            font-size: 1.1em;
        }
        
        /* কন্টেন্ট সেলস */
        .time-slot-cell { font-size: 0.9em; line-height: 1.3; min-width: 150px; }
        .slot-content-wrapper { padding: 5px; border-bottom: 1px dashed #ced4da; } 
        .slot-content-wrapper:last-child { border-bottom: none; } 
        
        /* রুটিন উপাদান */
        .slot-time { font-size: 0.8em; font-weight: bold; color: #6c757d; display: block; margin-bottom: 2px; } /* সময় গ্রে */
        .subject-name { font-weight: bold; color: #343a40; display: block; } /* বিষয় কালো */
        .teacher-name { color: #1e3a5f; font-weight: bold; } /* শিক্ষকের নাম গভীর নীল */

        /* সেশন কালার */
        .session-morning { background-color: #e6ffe6; } /* হালকা সবুজ */
        .session-day { background-color: #fff0e6; } /* হালকা কমলা */
    </style>
</head>
<body>

<div class="container-fluid">
    
    <div class="d-flex justify-content-between align-items-center mb-4 d-print-none">
        <a href="../../public/dashboard.php" class="btn btn-secondary">
      ← ড্যাশবোর্ডে ফিরুন
        </a>
        <button onclick="window.print()" class="btn btn-info">
              প্রিন্ট করুন 🖨️
        </button>
    </div>
    
    <div class="header-info">
        <h1>মিফতাহুন নাজাত মহিলা মাদরাসা</h1>
        <p>নেয়ামতপুর,সদর,নোয়াখালী</p>
        <p>রুটিন</p>
        <div class="report-title">
            <?php echo htmlspecialchars($report_title_exam); ?>
        </div>
    </div>
    
    <form method="GET" action="" class="mb-4 d-flex justify-content-center d-print-none">
        <div class="input-group" style="max-width: 800px;">
            <select name="exam_id" class="form-select w-25">
                <option value="0">-- পরীক্ষা নির্বাচন করুন --</option>
                <?php foreach ($exams as $id => $name): ?>
                    <option value="<?php echo $id; ?>" <?php echo ($selected_exam_id == $id) ? 'selected' : ''; ?>>
                        <?php echo $name; ?>
                    </option>
                <?php endforeach; ?>
            </select>

            <select name="class_id[]" class="form-select w-50" multiple size="4">
                <option value="0" disabled>-- একাধিক ক্লাস নির্বাচন করুন --</option>
                <?php foreach ($classes as $id => $name): ?>
                    <option value="<?php echo $id; ?>" <?php echo in_array($id, $selected_class_ids) ? 'selected' : ''; ?>>
                        <?php echo $name; ?>
                    </option>
                <?php endforeach; ?>
            </select>
            
            <button type="submit" class="btn btn-primary">দেখুন</button>
        </div>
    </form>
    <?php if (empty($ordered_classes) || empty($final_columns)): ?>
        <div class="alert alert-warning text-center">⚠️ ডেটাবেসে কোনো রুটিন ডেটা পাওয়া যায়নি বা নির্বাচিত পরীক্ষার/ক্লাসের জন্য কোনো রুটিন সেট করা হয়নি।</div>
    <?php else: ?>
    
    <div class="table-responsive">
        <table class="table table-bordered table-routine">
            <thead class="table-dark">
                <tr>
                    <th rowspan="3" class="class-header">শ্রেণি</th>
                    <?php 
                    $date_colspans = [];
                    foreach ($final_columns as $col) {
                        $date_colspans[$col['date']] = isset($date_colspans[$col['date']]) ? $date_colspans[$col['date']] + 1 : 1;
                    }

                    foreach ($date_colspans as $date => $colspan) {
                        $bangla_info = getBanglaDateAndDay($date);
                        echo "<th colspan='$colspan' class='date-row-header'>{$bangla_info['date']}</th>";
                    }
                    ?>
                </tr>
                
                <tr>
                    <?php 
                    foreach ($date_colspans as $date => $colspan) {
                        $bangla_info = getBanglaDateAndDay($date);
                        echo "<th colspan='$colspan' class='day-row-header'>{$bangla_info['day']}</th>";
                    }
                    ?>
                </tr>
                
                <tr>
                    <?php 
                    foreach ($final_columns as $col) {
                        $session_type_bn = ($col['session_type'] == 'morning') ? 'সকাল' : 'দিবা';
                        $cell_class = ($col['session_type'] == 'morning') ? 'session-morning' : 'session-day';
                        echo "<th class='$cell_class'>$session_type_bn</th>";
                    }
                    ?>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($ordered_classes as $class_name): ?>
                    <tr>
                        <td class="class-header"><?php echo $class_name; ?></td>
                        <?php 
                        foreach ($final_columns as $col) {
                            $sessionTypeKey = $col['session_type'];
                            $date = $col['date'];
                            $content = "";
                            
                            if (isset($grid_data[$class_name][$date][$sessionTypeKey])) {
                                $cell_contents = $grid_data[$class_name][$date][$sessionTypeKey];
                                
                                foreach($cell_contents as $subject_slot) {
                                    $content .= "<div class='slot-content-wrapper'>$subject_slot</div>";
                                }
                            } else {
                                $content = "—"; 
                            }
                            
                            $session_class = ($col['session_type'] == 'morning') ? 'session-morning' : 'session-day';
                            echo "<td class='time-slot-cell $session_class'>$content</td>";
                        }
                        ?>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <?php endif; ?>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>