<?php
// C:\xampp\htdocs\school_management\public\routines\routine_form.php

// 1. ডেটাবেস কানেকশন অন্তর্ভুক্ত করা
// যেহেতু এটি একটি পাবলিক ফোল্ডারের সাব-ফোল্ডারে আছে, তাই পাথ ঠিক করা হলো
include '../../includes/db_connection.php'; 

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// 2. ডেটাবেস থেকে সকল প্রয়োজনীয় ডেটা লোড করা
// সকল ক্লাস লোড করা
$classes_result = $conn->query("SELECT class_id, class_name FROM classes ORDER BY class_id"); 

// সকল শিক্ষক লোড করা
$teachers_result = $conn->query("SELECT teacher_id, first_name, last_name FROM teachers ORDER BY first_name"); 

// সকল পরীক্ষার নাম লোড করা
$exams_result = $conn->query("SELECT exam_id, exam_name FROM exams ORDER BY exam_id"); 

// রুটিনের ধরন 
$routine_types = ['class' => 'ক্লাস রুটিন', 'exam' => 'পরীক্ষার রুটিন'];
// সেশন ধরন
$session_types = ['morning' => 'সকাল', 'day' => 'দিবা'];

?>

<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>নতুন রুটিন এন্ট্রি</title>
    
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    
    <style>
        .container {
            max-width: 950px; 
            margin-top: 30px;
            padding: 20px;
        }
        .routine-row {
            border: 1px solid #ddd;
            padding: 20px;
            margin-bottom: 20px;
            border-radius: 8px;
            background-color: #f9f9f9;
            position: relative;
        }
        .remove-row-btn {
            position: absolute;
            top: 5px;
            right: 5px;
        }
        /* নতুন স্টাইল: বাটন এবং শিরোনামের লেআউট */
        .header-section {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
        }
        .header-section h2 {
            flex-grow: 1;
            text-align: center;
            margin: 0;
        }
    </style>
</head>
<body>

<div class="container">
    
    <div class="header-section">
        <a href="../../public/dashboard.php" class="btn btn-secondary btn-sm" style="background-color: #555;">
            <i class="fas fa-arrow-left"></i> ড্যাশবোর্ড
        </a>
        <h2 class="mb-0">📅 নতুন রুটিন এন্ট্রি</h2>
    </div>
    <?php if (isset($_GET['error'])): ?>
        <div class="alert alert-danger"><?php echo htmlspecialchars($_GET['error']); ?></div>
    <?php endif; ?>
    <?php if (isset($_GET['message'])): ?>
        <div class="alert alert-success"><?php echo htmlspecialchars($_GET['message']); ?></div>
    <?php endif; ?>


    <form method="POST" action="save_multiple_routine.php" id="routine-form">
        <div id="routine-rows-container">
        </div>

        <div class="d-flex justify-content-between align-items-center mt-4">
            <button type="button" class="btn btn-info add-row-btn" onclick="addRoutineRow()">➕ আরও একটি রুটিন যোগ করুন</button>
            <button type="submit" class="btn btn-success" id="submit-button">সেভ করুন</button>
        </div>
    </form>
</div>

<template id="routine-row-template">
    <div class="routine-row">
        <button type="button" class="btn btn-danger btn-sm remove-row-btn">🗑️ মুছে ফেলুন</button>
        <div class="row">
            <div class="col-md-4 mb-3">
                <label for="class_id" class="form-label">শ্রেণি নির্বাচন করুন: <span class="text-danger">*</span></label>
                <select class="form-select class-select" required>
                    <option value="">-- শ্রেণী --</option>
                    <?php 
                    // ক্লাস ডেটা টেমপ্লেটে পপুলেট করা
                    if ($classes_result->num_rows > 0) {
                        $classes_result->data_seek(0); 
                        while($row = $classes_result->fetch_assoc()): 
                    ?>
                        <option value="<?php echo $row['class_id']; ?>"><?php echo htmlspecialchars($row['class_name']); ?></option>
                    <?php endwhile; } ?>
                </select>
            </div>
            
            <div class="col-md-4 mb-3">
                <label for="subject_id" class="form-label">বিষয় নির্বাচন করুন: <span class="text-danger">*</span></label>
                <select class="form-select subject-select" required>
                    <option value="">-- বিষয় --</option>
                </select>
            </div>
            
            <div class="col-md-4 mb-3">
                <label for="teacher_id" class="form-label">শিক্ষক নির্বাচন করুন: <span class="text-danger">*</span></label>
                <select class="form-select teacher-select" required>
                    <option value="">-- শিক্ষক --</option>
                    <?php 
                    // শিক্ষক ডেটা টেমপ্লেটে পপুলেট করা
                    if ($teachers_result->num_rows > 0) {
                        $teachers_result->data_seek(0); 
                        while($row = $teachers_result->fetch_assoc()): 
                    ?>
                        <option value="<?php echo $row['teacher_id']; ?>"><?php echo htmlspecialchars($row['first_name'] . " " . $row['last_name']); ?></option>
                    <?php endwhile; } ?>
                </select>
            </div>
        </div>
        
        <div class="row">
            <div class="col-md-6 mb-3">
                <label for="routine_type" class="form-label">রুটিন ধরন: <span class="text-danger">*</span></label>
                <select class="form-select routine-type-select" required>
                    <?php foreach($routine_types as $key => $value): ?>
                        <option value="<?php echo $key; ?>"><?php echo $value; ?></option>
                    <?php endforeach; ?>
                </select>
            </div>

            <div class="col-md-6 mb-3 exam-id-group">
                <label for="exam_id" class="form-label">পরীক্ষার নাম (ঐচ্ছিক):</label>
                <select class="form-select exam-select">
                    <option value="0">-- পরীক্ষা নির্বাচন করুন --</option>
                    <?php 
                    // পরীক্ষার ডেটা টেমপ্লেটে পপুলেট করা
                    if ($exams_result->num_rows > 0) {
                        $exams_result->data_seek(0); 
                        while($row = $exams_result->fetch_assoc()): 
                    ?>
                        <option value="<?php echo $row['exam_id']; ?>"><?php echo htmlspecialchars($row['exam_name']); ?></option>
                    <?php endwhile; } ?>
                </select>
            </div>
        </div>
        
        <div class="row">
            <div class="col-md-3 mb-3">
                <label for="date_or_day" class="form-label">তারিখ/দিন: <span class="text-danger">*</span></label>
                <input type="date" class="form-control date-input" required> 
            </div>

            <div class="col-md-3 mb-3">
                <label for="start_time" class="form-label">শুরুর সময়: <span class="text-danger">*</span></label>
                <input type="time" class="form-control start-time-input" required>
            </div>
            
            <div class="col-md-3 mb-3">
                <label for="end_time" class="form-label">শেষের সময়: <span class="text-danger">*</span></label>
                <input type="time" class="form-control end-time-input" required>
            </div>
            
            <div class="col-md-3 mb-3">
                <label for="session_type" class="form-label">সেশন ধরন: <span class="text-danger">*</span></label>
                <select class="form-select session-type-select" required>
                    <?php foreach($session_types as $key => $value): ?>
                        <option value="<?php echo $key; ?>"><?php echo $value; ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
        </div>
    </div>
</template>

<script>
let routineRowIndex = 0;

$(document).ready(function() {
    addRoutineRow();

    // শ্রেণি পরিবর্তন হলে বিষয় লোড করা
    $('#routine-rows-container').on('change', '.class-select', function() {
        const classId = $(this).val();
        const $subjectSelect = $(this).closest('.routine-row').find('.subject-select');
        
        if (classId) {
            loadSubjects(classId, $subjectSelect);
        } else {
            $subjectSelect.html('<option value="">-- বিষয় --</option>');
        }
    });

    // রুটিনের ধরন পরিবর্তন হলে পরীক্ষার নাম ফিল্ড দেখানো/লুকানো
    $('#routine-rows-container').on('change', '.routine-type-select', function() {
        const routineType = $(this).val();
        const $examGroup = $(this).closest('.routine-row').find('.exam-id-group');
        const $examSelect = $(this).closest('.routine-row').find('.exam-select');
        
        if (routineType === 'exam') {
            $examGroup.show();
            // পরীক্ষার রুটিনের ক্ষেত্রে exam_id আবশ্যক
            $examSelect.prop('required', true).attr('name', $examSelect.attr('data-name'));
        } else {
            $examGroup.hide();
            // ক্লাস রুটিনের ক্ষেত্রে exam_id অপ্রয়োজনীয়/অব্যবহৃত, তাই required উঠিয়ে নেওয়া হলো।
            $examSelect.prop('required', false).removeAttr('name'); 
        }
    });

    // রো মুছে ফেলার ফাংশন
    $('#routine-rows-container').on('click', '.remove-row-btn', function() {
        if ($('.routine-row').length > 1) {
            $(this).closest('.routine-row').remove();
        } else {
            alert("কমপক্ষে একটি রুটিন এন্ট্রি রাখতে হবে।");
        }
    });
});

// AJAX দ্বারা বিষয় লোড করার ফাংশন
function loadSubjects(classId, $subjectSelect) {
    // লোডিং নির্দেশক যোগ করা
    $subjectSelect.html('<option value="">বিষয় লোড হচ্ছে...</option>'); 
    
    $.ajax({
        url: 'get_subjects_by_class.php', 
        type: 'GET',
        data: { class_id: classId },
        success: function(response) {
            // সাবজেক্ট লোডিং সফল হলে
            $subjectSelect.html(response); 
        },
        error: function() {
            $subjectSelect.html('<option value="">বিষয় লোড করা যায়নি</option>');
        }
    });
}

// নতুন রুটিন রো যুক্ত করার ফাংশন
function addRoutineRow() {
    const template = document.getElementById('routine-row-template');
    const newRow = template.content.cloneNode(true);
    const $newRow = $(newRow); 
    
    // রো এর ইনডেক্স ব্যবহার করে name অ্যাট্রিবিউট ডাইনামিকভাবে সেট করা
    // এখানে exam_id এর name অ্যাট্রিবিউটটি data-name এ সেভ করে রাখা হচ্ছে, কারণ এটি রুটিন টাইপ অনুযায়ী সরানো হবে।
    
    $newRow.find('.class-select').attr('name', `routines[${routineRowIndex}][class_id]`);
    $newRow.find('.subject-select').attr('name', `routines[${routineRowIndex}][subject_id]`);
    $newRow.find('.teacher-select').attr('name', `routines[${routineRowIndex}][teacher_id]`);
    $newRow.find('.routine-type-select').attr('name', `routines[${routineRowIndex}][routine_type]`);
    
    // exam_id এর name অ্যাট্রিবিউট data-name এ সেভ করা হচ্ছে
    $newRow.find('.exam-select').attr('data-name', `routines[${routineRowIndex}][exam_id]`);
    
    // DB কলামের নাম: exam_date (ক্লাস রুটিনের ক্ষেত্রে তারিখ না হয়ে দিন হতে পারে)
    $newRow.find('.date-input').attr('name', `routines[${routineRowIndex}][exam_date]`);
    
    $newRow.find('.start-time-input').attr('name', `routines[${routineRowIndex}][start_time]`);
    $newRow.find('.end-time-input').attr('name', `routines[${routineRowIndex}][end_time]`);
    $newRow.find('.session-type-select').attr('name', `routines[${routineRowIndex}][session_type]`);

    $('#routine-rows-container').append($newRow);
    
    // ডিফল্টভাবে পরীক্ষার ফিল্টারটি লুকানো এবং ইভেন্ট ট্রিগার করা
    $newRow.find('.routine-type-select').trigger('change'); 

    routineRowIndex++;
}
</script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>