<?php
// C:\xampp\htdocs\school_management\public\routines\get_subjects_by_class.php

// 1. ডেটাবেস কানেকশন অন্তর্ভুক্ত করা
// আপনার সঠিক পাথ নিশ্চিত করুন
include '../../includes/db_connection.php'; 

$output = '<option value="">-- বিষয় লোড করা যায়নি --</option>';

// 2. GET রিকোয়েস্ট থেকে class_id যাচাই করা
if (isset($_GET['class_id']) && is_numeric($_GET['class_id'])) {
    $class_id = intval($_GET['class_id']);
    
    // 3. SQL ক্যোয়ারি প্রস্তুত করা (class_subjects এবং subjects টেবিল জয়েন করা হয়েছে)
    $sql = "SELECT 
                cs.subject_id, 
                s.subject_name 
            FROM class_subjects cs
            INNER JOIN subjects s ON cs.subject_id = s.subject_id
            WHERE cs.class_id = ?
            ORDER BY s.subject_name ASC";
            
    $stmt = $conn->prepare($sql);
    
    if ($stmt) {
        $stmt->bind_param("i", $class_id);
        $stmt->execute();
        $result = $stmt->get_result();
        
        // 4. ডেটা লুপ করা এবং HTML অপশন তৈরি করা
        $output = '<option value="">-- বিষয় নির্বাচন করুন --</option>';
        if ($result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                $output .= '<option value="' . htmlspecialchars($row['subject_id']) . '">' 
                         . htmlspecialchars($row['subject_name']) 
                         . '</option>';
            }
        } else {
            // যদি সেই শ্রেণির জন্য কোনো বিষয় অ্যাসাইন করা না থাকে
            $output = '<option value="">এই শ্রেণির জন্য কোনো বিষয় অ্যাসাইন করা নেই</option>';
        }
        $stmt->close();
    } 
}

// 5. আউটপুট প্রিন্ট করা
echo $output;

// সংযোগ বন্ধ করা
if (isset($conn)) {
    $conn->close();
}
?>