<?php
session_start();
// ডেটাবেস সংযোগ পাথের সঠিকতা নিশ্চিত করুন
include '../../includes/db_connection.php'; 

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'Admin') {
    die("আপনার এই পাতা ব্যবহারের অনুমতি নেই।");
}

date_default_timezone_set('Asia/Dhaka');

// --- রিপোর্ট মাস নির্বাচন ---
// **দয়া করে আপনার প্রয়োজনীয় মাস এখানে দিন**
$target_month = '2025-10'; 

// --- A. সকল আয়ের খাত সংগ্রহ (ফি এবং অন্যান্য) ---
$income_items = ['Fee' => [], 'Other' => []];
$monthly_income = ['Fee' => [], 'Other' => []];
$total_monthly_income = 0.00;

// ১. ফি ক্যাটেগরি (income_categories) এবং মাসিক কালেকশন লোড করা
$fee_data_sql = "
    SELECT 
        ic.category_id AS id, 
        ic.category_name AS name, 
        SUM(CASE WHEN DATE_FORMAT(f.payment_date, '%Y-%m') = '{$target_month}' THEN f.amount ELSE 0 END) AS total_amount
    FROM income_categories ic
    LEFT JOIN fees f ON ic.category_id = f.category_id
    GROUP BY ic.category_id, ic.category_name
    ORDER BY ic.category_id ASC
";

$fee_result = $conn->query($fee_data_sql);

if ($fee_result) {
    while ($row = $fee_result->fetch_assoc()) {
        $id = $row['id'];
        $name = $row['name'];
        $amount = (float)$row['total_amount'];
        
        $income_items['Fee'][$id] = $name; 
        $monthly_income['Fee'][$id] = $amount;
        $total_monthly_income += $amount;
    }
}

// ====================================================================
// ** ডিসপ্লে ফিক্স: পূর্বের ভুল ম্যাপিং সংশোধন **
// এই লজিকটি শুধুমাত্র ডিসপ্লে নাম পরিবর্তন করবে।
// ====================================================================

$monthly_fee_id = null;
$residential_fee_id = null;
$exam_fee_id = null;

foreach ($income_items['Fee'] as $id => $name) {
    $trimmed_name = trim($name);
    
    if ($trimmed_name === 'মাসিক ফি') {
        $monthly_fee_id = $id;
    } elseif ($trimmed_name === 'আবাসিক ফি') {
        $residential_fee_id = $id;
    } elseif ($trimmed_name === 'পরীক্ষার ফি') {
        $exam_fee_id = $id;
    }
}

// ১. মাসিক ফি এবং আবাসিক ফি-এর নাম অদলবদল
if ($monthly_fee_id !== null && $residential_fee_id !== null) {
    // ধরে নিচ্ছি মাসিক ফি এর টাকা আবাসিক ফি এর ঘরে যাচ্ছে।
    $income_items['Fee'][$monthly_fee_id] = 'আবাসিক ফি'; 
    $income_items['Fee'][$residential_fee_id] = 'মাসিক ফি';
}

// ২. পরীক্ষার ফি-এর ডিসপ্লে নাম পরিবর্তন করে আবাসিক ফি করা
// ধরে নিচ্ছি আবাসিক ফি কালেকশন করলে পরীক্ষার ফি-এর ঘরে টাকা জমা হচ্ছে
if ($exam_fee_id !== null) {
    $income_items['Fee'][$exam_fee_id] = 'আবাসিক ফি';
}

// ====================================================================


// ২. অন্যান্য আয়ের খাত (income_sources) এবং মাসিক কালেকশন (other_incomes) লোড করা
// **এখানে income_sources টেবিল থেকে ডেটা লোড করার কোডটি ফিক্স করা হলো (source_id)**
$next_other_id = 1000;
$other_income_name_to_temp_id = [];
// isrc.source_id ব্যবহার করে সমস্ত সোর্স লোড করা হচ্ছে।
$other_sources_sql = "SELECT source_id, source_name FROM income_sources WHERE is_active = 1 ORDER BY source_name ASC";
$other_result = $conn->query($other_sources_sql);

if ($other_result) {
    while ($row = $other_result->fetch_assoc()) {
        $source_name = $row['source_name'];
        // source_id কে অস্থায়ী আইডি হিসেবে ব্যবহার করা হচ্ছে
        $temp_id = $row['source_id']; 
        
        $income_items['Other'][$temp_id] = $source_name;
        $other_income_name_to_temp_id[$source_name] = $temp_id;
    }
}

// অন্যান্য আয়ের পরিমাণ সংগ্রহ
$other_income_data_sql = "
    SELECT oi.income_source, SUM(oi.amount) AS total_amount
    FROM other_incomes oi
    WHERE DATE_FORMAT(oi.income_date, '%Y-%m') = '{$target_month}'
    GROUP BY oi.income_source
";
$other_income_data_result = $conn->query($other_income_data_sql);

if ($other_income_data_result) {
    while ($row = $other_income_data_result->fetch_assoc()) {
        $source_name = $row['income_source'];
        $amount = (float)$row['total_amount'];
        
        if (isset($other_income_name_to_temp_id[$source_name])) {
            $source_id = $other_income_name_to_temp_id[$source_name];
            $monthly_income['Other'][$source_id] = $amount;
            $total_monthly_income += $amount; 
        }
    }
}


// --- B. ব্যয়ের খাত (expense_categories) এবং মাসিক ব্যয় সংগ্রহ (expenses) ---
$expense_categories = [];
$monthly_expense = [];
$total_monthly_expense = 0.00;

$expense_data_sql = "
    SELECT 
        ec.category_id, 
        ec.category_name, 
        SUM(CASE WHEN DATE_FORMAT(e.expense_date, '%Y-%m') = '{$target_month}' THEN e.amount ELSE 0 END) AS total_amount
    FROM expense_categories ec
    LEFT JOIN expenses e ON ec.category_id = e.category_id
    WHERE ec.is_active = TRUE
    GROUP BY ec.category_id, ec.category_name
    ORDER BY ec.category_name ASC
";
$expense_result = $conn->query($expense_data_sql);

if ($expense_result) {
    while ($row = $expense_result->fetch_assoc()) {
        $category_id = $row['category_id'];
        $amount = (float)$row['total_amount'];
        
        $expense_categories[$category_id] = $row['category_name'];
        $monthly_expense[$category_id] = $amount;
        $total_monthly_expense += $amount;
    }
}

$net_profit_loss = $total_monthly_income - $total_monthly_expense;
$conn->close();


// ... [ get_bangla_month_name and format_to_bangla_number functions ] ...
function get_bangla_month_name($month_year) {
    $timestamp = strtotime($month_year . '-01');
    $month_name = date('F', $timestamp);
    $year = date('Y', $timestamp);
    
    $bangla_months = array(
        'January' => 'জানুয়ারি', 'February' => 'ফেব্রুয়ারি', 'March' => 'মার্চ',
        'April' => 'এপ্রিল', 'May' => 'মে', 'June' => 'জুন',
        'July' => 'জুলাই', 'August' => 'আগস্ট', 'September' => 'সেপ্টেম্বর',
        'October' => 'অক্টোবর', 'November' => 'নভেম্বর', 'December' => 'ডিসেম্বর'
    );
    
    $bangla_year = str_replace(range(0, 9), array('০', '১', '২', '৩', '৪', '৫', '৬', '৭', '৮', '৯'), $year);
    return $bangla_months[$month_name] . ' ' . $bangla_year;
}

function format_to_bangla_number($number) {
    $formatted_number = number_format($number, 0, '.', ''); 
    return str_replace(range(0, 9), array('০', '১', '২', '৩', '৪', '৫', '৬', '৭', '৮', '৯'), $formatted_number);
}


// --- সকল আয় খাতকে একটি একক অ্যারেতে তৈরি করা ---
$all_income_items_flat = array_merge($income_items['Fee'] ?? [], $income_items['Other'] ?? []);


// আয়ের খাত এবং ব্যয়ের খাতের সংখ্যা
$income_count = count($all_income_items_flat);
$expense_count = count($expense_categories);
$max_rows = max($income_count, $expense_count);

// এই ফাংশনটি আয়ের পরিমাণের জন্য সঠিক অ্যারে থেকে মান খুঁজবে
function get_income_amount($id, $income_items_master, $monthly_income) {
    // Fee ID গুলো (যা < 1000 ধরা হয়েছে)
    if ($id < 1000 && isset($income_items_master['Fee'][$id])) {
        return $monthly_income['Fee'][$id] ?? 0.00;
    } 
    // Other Income ID গুলো (যা >= 1000 হতে পারে, তবে এখানে source_id ব্যবহার করা হয়েছে)
    elseif (isset($income_items_master['Other'][$id])) {
        return $monthly_income['Other'][$id] ?? 0.00;
    }
    return 0.00;
}

?>

<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>মাসিক লাভ-ক্ষতি রিপোর্ট (T-ফরম্যাট)</title>
    <link rel="stylesheet" href="../../public/css/style.css"> 
    <style>
        .report-container { max-width: 800px; margin: 50px auto; padding: 0; background-color: #fff; border-radius: 8px; box-shadow: 0 0 20px rgba(0, 0, 0, 0.2); }
        h2 { text-align: center; color: #333; margin-bottom: 20px; padding: 10px 0; background-color: #e0f7fa; border-radius: 8px 8px 0 0; }
        .pnl-table { width: 100%; border-collapse: collapse; table-layout: fixed; }
        .pnl-table thead th { border: 2px solid #000; padding: 15px 10px; font-size: 1.2em; font-weight: bold; color: white; }
        .pnl-table .income-header { background-color: #4CAF50; }
        .pnl-table .expense-header { background-color: #FF5722; }
        .pnl-table tbody td { border: 1px solid #ddd; padding: 12px 10px; font-size: 1.1em; }
        .pnl-table .item-name { text-align: left; border-right: none; }
        .pnl-table .amount { text-align: right; border-left: none; }
        .pnl-table tr td:nth-child(2), .pnl-table tr td:nth-child(4) { border-right: 2px solid #000; }
        .pnl-table tr td:nth-child(1), .pnl-table tr td:nth-child(3) { border-left: 2px solid #000; }
        .total-row td { border-top: 3px double #000; font-weight: bold; background-color: #fffde7; }
        .net-result { padding: 15px 20px; text-align: center; border-top: 2px solid #000; background-color: #e0f2f1; font-weight: bold; font-size: 1.3em; color: #333; }
        .profit { color: #004d40; }
        .loss { color: #b71c1c; }
        .month-display { text-align: center; font-size: 1.1em; color: #555; margin-top: -10px; margin-bottom: 20px;}
    </style>
</head>
<body>
<div class="header">
    <h1>মাসিক লাভ-ক্ষতি রিপোর্ট</h1>
</div>

<div class="report-container">
    <h2>মাসিক আয় ও ব্যয় সারাংশ</h2>
    <div class="month-display">মাস: **<?php echo get_bangla_month_name($target_month); ?>**</div>
    
    <table class="pnl-table">
        <thead>
            <tr>
                <th colspan="2" class="income-header">প্রতিষ্ঠানিক আয়</th>
                <th colspan="2" class="expense-header">প্রতিষ্ঠানিক ব্যয়</th>
            </tr>
            <tr>
                <td class="item-name" style="border: 1px solid #000; font-weight: bold; background-color: #c8e6c9;">খাত</td>
                <td class="amount" style="border: 1px solid #000; font-weight: bold; background-color: #c8e6c9;">পরিমাণ (৳)</td>
                <td class="item-name" style="border: 1px solid #000; font-weight: bold; background-color: #ffcdd2;">খাত</td>
                <td class="amount" style="border: 1px solid #000; font-weight: bold; background-color: #ffcdd2;">পরিমাণ (৳)</td>
            </tr>
        </thead>
        <tbody>
            <?php 
            $income_keys = array_keys($all_income_items_flat);
            $expense_keys = array_keys($expense_categories);
            
            for ($i = 0; $i < $max_rows; $i++): 
            ?>
            <tr>
                <?php
                $income_name = '';
                $income_amount = 0.00;
                
                if (isset($income_keys[$i])) {
                    $id = $income_keys[$i];
                    $income_name = $all_income_items_flat[$id];
                    $income_amount = get_income_amount($id, $income_items, $monthly_income);
                }
                ?>
                <td class="item-name"><?php echo htmlspecialchars($income_name); ?></td>
                <td class="amount"><?php echo $income_amount > 0 ? format_to_bangla_number($income_amount) : ''; ?></td>

                <?php
                $expense_name = '';
                $expense_amount = 0.00;

                if (isset($expense_keys[$i])) {
                    $id = $expense_keys[$i];
                    $expense_name = $expense_categories[$id];
                    $expense_amount = $monthly_expense[$id] ?? 0.00;
                }
                ?>
                <td class="item-name"><?php echo htmlspecialchars($expense_name); ?></td>
                <td class="amount"><?php echo $expense_amount > 0 ? format_to_bangla_number($expense_amount) : ''; ?></td>
            </tr>
            <?php endfor; ?>
            
            <tr class="total-row">
                <td class="item-name">মোট আয়</td>
                <td class="amount"><?php echo format_to_bangla_number($total_monthly_income); ?></td>
                <td class="item-name">মোট ব্যয়</td>
                <td class="amount"><?php echo format_to_bangla_number($total_monthly_expense); ?></td>
            </tr>
        </tbody>
    </table>
    
    <?php 
        $result_text = '';
        $result_class = '';
        if ($net_profit_loss >= 0) {
            $result_text = 'নিট লাভ: ' . format_to_bangla_number(abs($net_profit_loss));
            $result_class = 'profit';
        } else {
            $result_text = 'নিট ক্ষতি: ' . format_to_bangla_number(abs($net_profit_loss));
            $result_class = 'loss';
        }
    ?>
    <div class="net-result">
        ফলাফল: <span class="<?php echo $result_class; ?>"><?php echo $result_text; ?> ৳</span>
    </div>
</div>

</body>
</html>