<?php
include '../includes/db_connection.php'; // ডাটাবেস সংযোগ ফাইল

$message = '';
$error = '';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // ফর্ম থেকে ডেটা সংগ্রহ
    $username = trim($_POST['username']);
    $email = trim($_POST['email']);
    $password = $_POST['password'];
    $role = $_POST['role'];
    $confirm_password = $_POST['confirm_password'];

    // প্রাথমিক ডেটা বৈধতা (Validation)
    if (empty($username) || empty($email) || empty($password) || empty($role) || empty($confirm_password)) {
        $error = "সবগুলো ফিল্ড পূরণ করা আবশ্যক।";
    } elseif ($password !== $confirm_password) {
        $error = "পাসওয়ার্ড নিশ্চিতকরণের সাথে মিলছে না।";
    } elseif (strlen($password) < 6) {
        $error = "পাসওয়ার্ড কমপক্ষে ৬ অক্ষরের হতে হবে।";
    } else {
        // পাসওয়ার্ডকে সুরক্ষিতভাবে হ্যাশ করা
        $hashed_password = password_hash($password, PASSWORD_DEFAULT);

        // ইউজারনেম বা ইমেইল ইতিমধ্যে আছে কিনা, তা পরীক্ষা করা
        $check_sql = "SELECT user_id FROM users WHERE username = ? OR email = ?";
        $check_stmt = $conn->prepare($check_sql);
        $check_stmt->bind_param("ss", $username, $email);
        $check_stmt->execute();
        $check_stmt->store_result();

        if ($check_stmt->num_rows > 0) {
            $error = "এই ইউজারনেম বা ইমেইল দিয়ে ইতিমধ্যে একটি অ্যাকাউন্ট বিদ্যমান।";
        } else {
            // নতুন ব্যবহারকারী যোগ করা
            $insert_sql = "INSERT INTO users (username, email, password_hash, role) VALUES (?, ?, ?, ?)";
            $insert_stmt = $conn->prepare($insert_sql);
            $insert_stmt->bind_param("ssss", $username, $email, $hashed_password, $role);
            
            if ($insert_stmt->execute()) {
                $message = "অ্যাকাউন্ট সফলভাবে তৈরি হয়েছে! আপনি এখন লগইন করতে পারেন।";
                // ফর্ম জমা দেওয়ার পর ফিল্ড খালি করা
                $username = $email = ''; 
            } else {
                $error = "অ্যাকাউন্ট তৈরি করার সময় সমস্যা হয়েছে: " . $insert_stmt->error;
            }
            $insert_stmt->close();
        }
        $check_stmt->close();
    }
}
?>

<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>নতুন অ্যাকাউন্ট তৈরি</title>
    <link rel="stylesheet" href="css/style.css">
    <style>
        body {
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            background-color: #f4f4f4;
        }
        .container {
            max-width: 400px;
            padding: 30px;
            background: #fff;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            border-radius: 8px;
            text-align: center;
        }
        .container h2 {
            margin-bottom: 20px;
            color: #333;
        }
        .form-group {
            margin-bottom: 15px;
            text-align: left;
        }
        .form-group label {
            display: block;
            margin-bottom: 5px;
            font-weight: bold;
        }
        .form-group input, .form-group select {
            width: 100%;
            padding: 10px;
            border: 1px solid #ccc;
            border-radius: 4px;
            box-sizing: border-box;
        }
        .message, .error {
            padding: 10px;
            margin-bottom: 15px;
            border-radius: 4px;
            font-weight: bold;
        }
        .message {
            background-color: #d4edda;
            color: #155724;
        }
        .error {
            background-color: #f8d7da;
            color: #721c24;
        }
        .login-link {
            display: block;
            margin-top: 15px;
            color: #007bff;
            text-decoration: none;
        }
        .login-link:hover {
            text-decoration: underline;
        }
    </style>
</head>
<body>
<div class="container">
    <h2>নতুন অ্যাকাউন্ট তৈরি করুন</h2>
    
    <?php if ($message): ?>
        <p class="message"><?php echo $message; ?></p>
    <?php endif; ?>
    <?php if ($error): ?>
        <p class="error"><?php echo $error; ?></p>
    <?php endif; ?>
    
    <form method="POST" action="">
        <div class="form-group">
            <label for="username">ইউজারনেম:</label>
            <input type="text" id="username" name="username" required value="<?php echo htmlspecialchars($username ?? ''); ?>">
        </div>
        
        <div class="form-group">
            <label for="email">ইমেইল:</label>
            <input type="email" id="email" name="email" required value="<?php echo htmlspecialchars($email ?? ''); ?>">
        </div>
        
        <div class="form-group">
            <label for="password">পাসওয়ার্ড:</label>
            <input type="password" id="password" name="password" required>
        </div>
        
        <div class="form-group">
            <label for="confirm_password">পাসওয়ার্ড নিশ্চিত করুন:</label>
            <input type="password" id="confirm_password" name="confirm_password" required>
        </div>

        <div class="form-group">
            <label for="role">ভূমিকা (Role):</label>
            <select id="role" name="role" required>
                <option value="Accountant">Accountant</option>
                <option value="Teacher">Teacher</option>
                <option value="Admin">Admin</option>
            </select>
        </div>
        
        <button type="submit" class="btn-primary" style="width: 100%;">রেজিস্টার</button>
    </form>
    
    <a href="index.php" class="login-link">ইতিমধ্যে অ্যাকাউন্ট আছে? লগইন করুন</a>
</div>
</body>
</html>