<?php
session_start();
// নিশ্চিত করুন যে শুধুমাত্র অ্যাডমিন এই পেজটি অ্যাক্সেস করতে পারবে
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'Admin') {
    header("Location: ../../index.php");
    exit;
}

// ডেটাবেস সংযোগ
include '../../includes/db_connection.php';
date_default_timezone_set('Asia/Dhaka');

$message = "";

// ফাইল আপলোডের কনস্ট্যান্ট
$target_dir = "../../uploads/notices/"; // নিশ্চিত করুন যে এই ফোল্ডারটি বিদ্যমান এবং রাইটেবল
$max_file_size = 5 * 1024 * 1024; // 5MB

// ১. নতুন নোটিস যোগ করা
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['add_notice'])) {
    $title = $conn->real_escape_string($_POST['title']);
    $content = $conn->real_escape_string($_POST['content']); 
    $publish_date = $conn->real_escape_string($_POST['publish_date']);
    $expiry_date = !empty($_POST['expiry_date']) ? $conn->real_escape_string($_POST['expiry_date']) : NULL;
    $file_path_db = NULL;
    $uploadOk = 1;

    // শিরোনাম (Title) বাধ্যতামূলক
    if (empty($title)) {
        $message = "<div class='alert error'>❌ নোটিসের শিরোনাম অবশ্যই দিতে হবে।</div>";
        $uploadOk = 0;
    }

    // --- ফাইল আপলোড হ্যান্ডলিং ---
    if ($uploadOk == 1 && isset($_FILES["notice_file"]) && $_FILES["notice_file"]["error"] == UPLOAD_ERR_OK) {
        $file = $_FILES["notice_file"];
        $file_name = basename($file["name"]);
        $file_type = pathinfo($file_name, PATHINFO_EXTENSION);
        
        // ফাইলকে ইউনিক নাম দেওয়া (নামের কনফ্লিক্ট এড়াতে)
        $new_file_name = uniqid('notice_', true) . "." . strtolower($file_type);
        $target_file = $target_dir . $new_file_name;

        // শুধু PDF ফাইল চেক করা
        if (strtolower($file_type) != "pdf") {
            $message = "<div class='alert error'>❌ শুধুমাত্র **PDF** ফাইল আপলোড করার অনুমতি আছে।</div>";
            $uploadOk = 0;
        }

        // ফাইলের আকার চেক করা
        if ($file["size"] > $max_file_size) {
            $message = "<div class='alert error'>❌ ফাইলের আকার 5MB এর বেশি হওয়া উচিত নয়।</div>";
            $uploadOk = 0;
        }

        if ($uploadOk == 1) {
            // ফোল্ডার না থাকলে তৈরি করা
            if (!is_dir($target_dir)) {
                mkdir($target_dir, 0777, true);
            }

            // ফাইল সার্ভারে আপলোড করা
            if (move_uploaded_file($file["tmp_name"], $target_file)) {
                $file_path_db = $conn->real_escape_string($new_file_name); // ডেটাবেসে শুধু ইউনিক নাম সংরক্ষণ
            } else {
                $message = "<div class='alert error'>❌ ফাইল আপলোডে একটি ত্রুটি হয়েছে। ফোল্ডারের পারমিশন চেক করুন।</div>";
                $uploadOk = 0;
            }
        }
    } 
    // যদি কোনো ফাইল আপলোড না হয় এবং সংক্ষিপ্ত বর্ণনাও না থাকে
    else if ($uploadOk == 1 && empty($content) && !isset($_FILES["notice_file"])) {
        $message = "<div class='alert error'>❌ নোটিসের জন্য হয় PDF ফাইল আপলোড করুন, অথবা সংক্ষিপ্ত বর্ণনা প্রদান করুন।</div>";
        $uploadOk = 0;
    }


    if ($uploadOk == 1) {
        $file_path_sql = $file_path_db ? "'$file_path_db'" : "NULL";
        $expiry_date_sql = $expiry_date ? "'$expiry_date'" : "NULL";

        $sql = "INSERT INTO notices (title, content, publish_date, expiry_date, file_path) 
                VALUES ('$title', '$content', '$publish_date', $expiry_date_sql, $file_path_sql)";

        if ($conn->query($sql) === TRUE) {
            $message = "<div class='alert success'>✅ নতুন নোটিস সফলভাবে যুক্ত করা হয়েছে! " . ($file_path_db ? " (PDF আপলোড হয়েছে: **$file_path_db**)" : "") . "</div>";
        } else {
            $message = "<div class='alert error'>❌ নোটিস যুক্ত করতে সমস্যা হয়েছে: " . $conn->error . "</div>";
            // ডেটাবেস ইনসার্ট ব্যর্থ হলে আপলোড করা ফাইল ডিলিট করে দেওয়া
            if ($file_path_db && file_exists($target_dir . $file_path_db)) {
                unlink($target_dir . $file_path_db);
            }
        }
    }
}

// ২. নোটিস ডিলিট করা (এবং ফাইল ডিলিট করা)
if (isset($_GET['action']) && $_GET['action'] == 'delete' && isset($_GET['id'])) {
    $notice_id = (int)$_GET['id'];
    
    // ডিলিট করার আগে ফাইলের পাথ ফেচ করা
    $fetch_sql = "SELECT file_path FROM notices WHERE notice_id = $notice_id";
    $fetch_result = $conn->query($fetch_sql);
    $file_to_delete = $fetch_result->fetch_assoc()['file_path'] ?? NULL;

    $sql = "DELETE FROM notices WHERE notice_id = $notice_id";
    if ($conn->query($sql) === TRUE) {
        // সার্ভার থেকে ফাইল ডিলিট করা
        if ($file_to_delete && file_exists($target_dir . $file_to_delete)) {
            unlink($target_dir . $file_to_delete);
        }
        $message = "<div class='alert success'>🗑️ নোটিস সফলভাবে মুছে ফেলা হয়েছে।</div>";
        header("Location: notices_list.php");
        exit;
    } else {
        $message = "<div class='alert error'>❌ নোটিস মুছে ফেলা সম্ভব হয়নি: " . $conn->error . "</div>";
    }
}

// ৩. বিদ্যমান নোটিসগুলি ফেচ করা
$notices_sql = "SELECT * FROM notices ORDER BY publish_date DESC, notice_id DESC";
$notices_result = $conn->query($notices_sql);

$conn->close();
?>

<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>নোটিস ও সার্কুলার ব্যবস্থাপনা</title>
    <link rel="stylesheet" href="../../public/css/style.css">
    <style>
        .container { max-width: 1200px; margin: 20px auto; padding: 20px; background-color: #fff; border-radius: 8px; box-shadow: 0 0 10px rgba(0, 0, 0, 0.1); }
        .form-section, .list-section { margin-bottom: 30px; padding: 20px; border: 1px solid #ddd; border-radius: 5px; background-color: #f9f9f9; }
        .form-section h3 { border-bottom: 2px solid #3498db; padding-bottom: 10px; color: #3498db; }
        .form-group { margin-bottom: 15px; }
        .form-group label { display: block; margin-bottom: 5px; font-weight: bold; }
        .form-group input[type="text"], .form-group input[type="date"], .form-group textarea, .form-group input[type="file"] { width: 100%; padding: 10px; border: 1px solid #ccc; border-radius: 4px; box-sizing: border-box; }
        .form-group textarea { resize: vertical; min-height: 80px; } /* ছোট করা হলো */
        .submit-btn { background-color: #2ecc71; color: white; padding: 10px 15px; border: none; border-radius: 4px; cursor: pointer; font-size: 16px; transition: background-color 0.3s; }
        .submit-btn:hover { background-color: #27ae60; }
        
        table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        table, th, td { border: 1px solid #ddd; }
        th, td { padding: 12px; text-align: left; }
        th { background-color: #34495e; color: white; }
        tr:nth-child(even) { background-color: #f2f2f2; }
        .action-links a { margin-right: 10px; text-decoration: none; padding: 5px 10px; border-radius: 3px; }
        .delete-btn { background-color: #e74c3c; color: white; }
        .delete-btn:hover { background-color: #c0392b; }
        .alert { padding: 10px; margin-bottom: 15px; border-radius: 4px; font-weight: bold; }
        .alert.success { background-color: #d4edda; color: #155724; border-color: #c3e6cb; }
        .alert.error { background-color: #f8d7da; color: #721c24; border-color: #f5c6cb; }
    </style>
</head>
<body>
<div class="header">
    <h1>নোটিস বোর্ড</h1>
    <a href="../dashboard.php" class="back-link">ড্যাশবোর্ড</a>
</div>

<div class="container">
    <?php echo $message; ?>

    <div class="form-section">
        <h3>➕ নতুন নোটিস প্রকাশ করুন</h3>
        <form method="POST" action="notices_list.php" enctype="multipart/form-data"> 
            <input type="hidden" name="add_notice" value="1">
            <div class="form-group">
                <label for="title">শিরোনাম (বাধ্যতামূলক):</label>
                <input type="text" id="title" name="title" required>
            </div>

            <div class="form-group">
                <label for="notice_file">**PDF ফাইল আপলোড করুন (ঐচ্ছিক):**</label>
                <input type="file" id="notice_file" name="notice_file" accept=".pdf">
                <small style="color: #666; font-weight: bold;">সর্বোচ্চ 5MB, শুধুমাত্র **PDF** ফাইল।</small>
            </div>
            <div class="form-group">
                <label for="content">সংক্ষিপ্ত বর্ণনা (ঐচ্ছিক):</label>
                <textarea id="content" name="content" rows="3"></textarea>
                <small style="color: #666;">পিডিএফ আপলোড না করলে এটি মূল নোটিস হিসেবে প্রদর্শিত হবে।</small>
            </div>

            <div class="form-group">
                <label for="publish_date">প্রকাশের তারিখ:</label>
                <input type="date" id="publish_date" name="publish_date" value="<?php echo date('Y-m-d'); ?>" required>
            </div>
            <div class="form-group">
                <label for="expiry_date">শেষ দিন (ঐচ্ছিক):</label>
                <input type="date" id="expiry_date" name="expiry_date">
            </div>
            <button type="submit" class="submit-btn">নোটিস প্রকাশ করুন</button>
        </form>
    </div>

    <div class="list-section">
        <h3>📝 বিদ্যমান নোটিসগুলির তালিকা</h3>
        <table>
            <thead>
                <tr>
                    <th>আইডি</th>
                    <th>শিরোনাম ও বিষয়বস্তু</th>
                    <th>প্রকাশের তারিখ</th>
                    <th>শেষ দিন</th>
                    <th>অ্যাকশন</th>
                </tr>
            </thead>
            <tbody>
                <?php
                if ($notices_result && $notices_result->num_rows > 0) {
                    while($notice = $notices_result->fetch_assoc()) {
                        $expiry_display = $notice['expiry_date'] ? date('d-m-Y', strtotime($notice['expiry_date'])) : '—';
                        ?>
                        <tr>
                            <td><?php echo $notice['notice_id']; ?></td>
                            <td>
                                <strong><?php echo htmlspecialchars($notice['title']); ?></strong>
                                <br>
                                <?php if ($notice['file_path']): ?>
                                    <a href="../../uploads/notices/<?php echo urlencode($notice['file_path']); ?>" 
                                       target="_blank" 
                                       style="color: #e74c3c; font-weight: bold; text-decoration: none;">
                                        ⬇️ নোটিস ডাউনলোড করুন (**PDF**)
                                    </a>
                                <?php elseif ($notice['content']): ?>
                                    <small style="color: #555;"><?php echo mb_substr(htmlspecialchars($notice['content']), 0, 100) . (mb_strlen($notice['content']) > 100 ? '...' : ''); ?></small>
                                <?php else: ?>
                                     <small style="color: #999;">কোনো ফাইল বা বর্ণনা নেই।</small>
                                <?php endif; ?>
                            </td>
                            <td><?php echo date('d-m-Y', strtotime($notice['publish_date'])); ?></td>
                            <td><?php echo $expiry_display; ?></td>
                            <td class="action-links">
                                <a href="notices_list.php?action=delete&id=<?php echo $notice['notice_id']; ?>" 
                                   class="delete-btn" 
                                   onclick="return confirm('আপনি কি নিশ্চিত যে এই নোটিসটি এবং এর সাথে যুক্ত ফাইলটি মুছে ফেলতে চান?');">
                                    মুছুন
                                </a>
                            </td>
                        </tr>
                        <?php
                    }
                } else {
                    echo "<tr><td colspan='5'>এখনও কোনো নোটিস যুক্ত করা হয়নি।</td></tr>";
                }
                ?>
            </tbody>
        </table>
    </div>
</div>

</body>
</html>