<?php
session_start();
include '../includes/db_connection.php';

$error_message = "";

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $username = $_POST['username'];
    $password = $_POST['password'];

    // SQL ক্যোয়ারি: ইউজারনেম দিয়ে ব্যবহারকারীকে খোঁজা হচ্ছে
    $sql = "SELECT user_id, username, password_hash, role, related_id FROM users WHERE username = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $username);
    $stmt->execute();
    $result = $stmt->get_result();
    $user = $result->fetch_assoc();

    // পাসওয়ার্ড যাচাই এবং লগইন সফল হলে সেশন সেট করা
    if ($user && password_verify($password, $user['password_hash'])) {
        $_SESSION['user_id'] = $user['user_id'];
        $_SESSION['username'] = $user['username'];
        $_SESSION['role'] = $user['role'];
        $_SESSION['related_id'] = $user['related_id'];
        header("Location: dashboard.php");
        exit();
    } else {
        $error_message = "ইউজারনেম বা পাসওয়ার্ড ভুল।"; // বাংলা অনুবাদ
    }
    $stmt->close();
}
?>

<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>লগইন - স্কুল ম্যানেজমেন্ট সিস্টেম</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        /* ফন্ট পরিবর্তন (বাংলা ফন্টের জন্য) */
        @import url('https://fonts.googleapis.com/css2?family=Tiro+Bangla&display=swap');
        
        body {
            /* আকর্ষণীয় গ্রেডিয়েন্ট ব্যাকগ্রাউন্ড */
            background: linear-gradient(135deg, #74ebd5 0%, #9face6 100%);
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            margin: 0;
            font-family: 'Tiro Bangla', sans-serif;
            flex-direction: column; /* উপরে এবং নিচে কন্টেন্ট যোগ করার জন্য */
            padding: 20px 0;
        }

        /* --- Header (স্কুলের নাম) স্টাইল --- */
        .page-header {
            text-align: center;
            color: #34495e;
            margin-bottom: 20px;
        }
        .page-header h1 {
            font-size: 2.2em;
            margin: 0;
            font-weight: 700;
        }
        .page-header p {
            font-size: 1.1em;
            margin-top: 5px;
            color: #2c3e50;
        }
        /* --- Header স্টাইল শেষ --- */

        .container {
            max-width: 400px;
            width: 90%; 
            padding: 40px;
            background: rgba(255, 255, 255, 0.95); 
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.2); 
            border-radius: 12px;
            text-align: center;
            backdrop-filter: blur(5px); 
        }
        .container h2 {
            margin-bottom: 30px;
            color: #34495e; 
            font-size: 28px;
            border-bottom: 2px solid #9face6;
            padding-bottom: 10px;
        }
        .form-group {
            margin-bottom: 20px;
            position: relative;
        }
        .form-group i {
            position: absolute;
            top: 50%;
            left: 15px;
            transform: translateY(-50%);
            color: #7f8c8d;
        }
        .container input[type="text"], 
        .container input[type="password"] {
            width: 100%;
            padding: 12px 12px 12px 40px; 
            border: 1px solid #bdc3c7;
            border-radius: 6px;
            box-sizing: border-box;
            font-size: 16px;
            transition: border-color 0.3s;
        }
        .container input[type="text"]:focus, 
        .container input[type="password"]:focus {
            border-color: #3498db; 
            outline: none;
        }
        .container input[type="submit"] {
            background-color: #3498db; 
            color: white;
            padding: 12px 15px;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            width: 100%;
            font-size: 18px;
            font-weight: bold;
            transition: background-color 0.3s;
        }
        .container input[type="submit"]:hover {
            background-color: #2980b9;
        }
        .error-message {
            color: #e74c3c;
            background-color: #fceae9;
            padding: 10px;
            border-radius: 4px;
            margin-bottom: 20px;
            font-weight: bold;
        }
        .register-link {
            display: block;
            margin-top: 25px;
            color: #27ae60; 
            text-decoration: none;
            font-weight: 600;
            font-size: 15px;
            transition: color 0.3s;
        }
        .register-link:hover {
            color: #2ecc71;
            text-decoration: underline;
        }
        /* --- Footer (কপিরাইট) স্টাইল --- */
        .page-footer {
            margin-top: 30px;
            color: #2c3e50;
            font-size: 0.9em;
            text-align: center;
        }
        .page-footer p {
            margin: 5px 0;
        }
        /* --- Footer স্টাইল শেষ --- */
    </style>
</head>
<body>

    <div class="page-header">
        <h1>মিফতাহুন নাজাত মহিলা মাদরাসা</h1>
        <p>— আদর্শ ও প্রযুক্তির সমন্বয়ে যুগোপযোগী শিক্ষা —</p>
    </div>
    <div class="container">
        <h2><i class="fas fa-sign-in-alt"></i> লগইন</h2>
        
        <form action="" method="POST">
            <?php if ($error_message): ?>
                <p class="error-message"><?php echo $error_message; ?></p>
            <?php endif; ?>
            
            <div class="form-group">
                <label for="username" class="sr-only">ইউজারনেম:</label>
                <i class="fas fa-user"></i> 
                <input type="text" id="username" name="username" placeholder="ইউজারনেম দিন" required>
            </div>
            
            <div class="form-group">
                <label for="password" class="sr-only">পাসওয়ার্ড:</label>
                <i class="fas fa-lock"></i> 
                <input type="password" id="password" name="password" placeholder="পাসওয়ার্ড দিন" required>
            </div>
            
            <input type="submit" value="লগইন করুন">
        </form>
        
        <a href="register.php" class="register-link"><i class="fas fa-user-plus"></i> নতুন অ্যাকাউন্ট তৈরি করুন</a> 
    </div>

    <div class="page-footer">
        <p>&copy; <?php echo date("Y"); ?> স্কুল ম্যানেজমেন্ট সিস্টেম। সর্বস্বত্ব সংরক্ষিত।</p>
        <p>ডিজাইন ও ডেভেলপমেন্ট: **আরমান**</p>
    </div>
    </body>
</html>

<?php
$conn->close();
?>