<?php
session_start();
include '../../includes/db_connection.php'; 

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'Admin') {
    die("আপনার এই পাতা ব্যবহারের অনুমতি নেই।");
}

$message = '';
$error = '';

// --- ডিলিট অপারেশন হ্যান্ডেল করা ---
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['delete_source_id'])) {
    $source_id = $_POST['delete_source_id'];
    
    // সতর্কতা: এই উৎসটি অন্য কোনো আয়ের রেকর্ডে ব্যবহৃত হয়েছে কি না, তা পরীক্ষা করা জরুরি।
    // আপাতত সরাসরি ডিলিট করা হচ্ছে।

    $sql = "DELETE FROM income_sources WHERE source_id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $source_id);
    
    if ($stmt->execute()) {
        $message = "আয়ের উৎস সফলভাবে মুছে ফেলা হয়েছে!";
    } else {
        // এই এরর মেসেজটি ForeignKey Constraint Violation হ্যান্ডেল করতে সাহায্য করবে
        $error = "হিসাব মোছার সময় সমস্যা হয়েছে। নিশ্চিত করুন যে উৎসটি অন্য কোনো আয়ের রেকর্ডে ব্যবহৃত হয়নি।";
    }
    $stmt->close();
}

// আয়ের উৎসের তথ্য সংগ্রহ
$sql = "SELECT * FROM income_sources ORDER BY source_id DESC";
$result = $conn->query($sql);
$sources = $result->fetch_all(MYSQLI_ASSOC);

$conn->close();
?>

<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>আয়ের উৎসের তালিকা</title>
    <link rel="stylesheet" href="../../public/css/style.css"> 
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        /* মূল কন্টেইনার এবং ব্যাকগ্রাউন্ড */
        .content {
            padding: 20px;
            position: relative;
        }
        .container {
            max-width: 900px;
            margin: 0 auto;
            padding: 30px;
            background-color: #ffffff;
            border-radius: 10px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
        }
        .container h2 {
            text-align: center;
            color: #34495e;
            margin-bottom: 25px;
            border-bottom: 3px solid #3498db;
            padding-bottom: 10px;
            font-size: 24px;
        }
        
        /* ব্যাক বাটন স্টাইল */
        .back-button {
            position: absolute;
            top: 20px;
            left: 20px;
            background-color: #34495e;
            color: white;
            padding: 10px 15px;
            border-radius: 5px;
            text-decoration: none;
            font-weight: bold;
            display: inline-flex;
            align-items: center;
            gap: 5px;
            transition: background-color 0.3s;
        }
        .back-button:hover {
            background-color: #2c3e50;
        }
        
        /* মেসেজ স্টাইল */
        .message-success, .message-error {
            padding: 12px;
            margin-bottom: 20px;
            border-radius: 5px;
            font-weight: bold;
            text-align: center;
        }
        .message-success {
            color: #155724;
            background-color: #d4edda;
            border: 1px solid #c3e6cb;
        }
        .message-error {
            color: #721c24;
            background-color: #f8d7da;
            border: 1px solid #f5c6cb;
        }

        /* কন্ট্রোল বাটন গ্রুপ */
        .control-buttons {
            display: flex;
            justify-content: flex-start;
            gap: 15px;
            margin-bottom: 20px;
            flex-wrap: wrap;
        }
        .control-buttons a.button {
            padding: 10px 18px;
            border-radius: 5px;
            text-decoration: none;
            font-weight: bold;
            display: inline-flex;
            align-items: center;
            gap: 8px;
            transition: background-color 0.3s;
        }
        .control-buttons a.add-btn { background-color: #2ecc71; color: white; }
        .control-buttons a.list-btn { background-color: #3498db; color: white; }
        .control-buttons a.add-btn:hover { background-color: #27ae60; }
        .control-buttons a.list-btn:hover { background-color: #2980b9; }

        /* টেবিল স্টাইল */
        .list-container table { 
            width: 100%; 
            border-collapse: separate; /* বর্ডার সেপারেট করা হয়েছে */
            border-spacing: 0;
            margin-top: 20px; 
            border: 1px solid #e0e0e0;
            border-radius: 8px;
            overflow: hidden; /* বর্ডার রেডিয়াস দেখানোর জন্য */
        }
        .list-container th, .list-container td { 
            border: none; 
            padding: 15px 12px; 
            text-align: left; 
            font-size: 15px; 
        }
        .list-container th { 
            background-color: #34495e; 
            color: white; 
            font-weight: bold;
            text-transform: uppercase;
        }
        .list-container tr:nth-child(even) { background-color: #f7f9f9; }
        .list-container tr:hover { background-color: #ecf0f1; }
        
        /* স্ট্যাটাস ব্যাজ */
        .status-active { background-color: #d4edda; color: #155724; padding: 5px 10px; border-radius: 4px; font-weight: bold; }
        .status-inactive { background-color: #f8d7da; color: #721c24; padding: 5px 10px; border-radius: 4px; font-weight: bold; }

        /* অ্যাকশন বাটন স্টাইল */
        .actions a, .actions button { 
            padding: 8px 12px; 
            border-radius: 5px; 
            font-size: 14px; 
            text-decoration: none; 
            border: none; 
            cursor: pointer; 
            transition: background-color 0.3s;
            margin-right: 5px;
        }
        .actions .edit-btn { background-color: #f39c12; color: white; }
        .actions .delete-btn { background-color: #e74c3c; color: white; }
        .actions .edit-btn:hover { background-color: #d35400; }
        .actions .delete-btn:hover { background-color: #c0392b; }
    </style>
</head>
<body>
<div class="header">
    <h1>আয়ের উৎসের ব্যবস্থাপনা</h1>
</div>

<a href="../../public/dashboard.php" class="back-button">
    <i class="fas fa-arrow-left"></i> ড্যাশবোর্ড
</a>

<div class="content">
    <div class="container">
        <h2><i class="fas fa-list-alt"></i> আয়ের উৎসের তালিকা</h2>
        
        <?php if ($message): ?>
            <p class="message-success"><i class="fas fa-check-circle"></i> <?php echo $message; ?></p>
        <?php endif; ?>
        
        <?php if ($error): ?>
            <p class="message-error"><i class="fas fa-exclamation-triangle"></i> <?php echo $error; ?></p>
        <?php endif; ?>
        
        <div class="control-buttons">
            <a href="add_source.php" class="button add-btn"><i class="fas fa-plus-circle"></i> নতুন উৎস যোগ করুন</a>
            <a href="income_list.php" class="button list-btn"><i class="fas fa-clipboard-list"></i> আয়ের তালিকায় ফিরে যান</a>
        </div>

        <div class="list-container">
            <table>
                <thead>
                    <tr>
                        <th>আইডি</th>
                        <th>উৎস নাম</th>
                        <th>অবস্থা</th>
                        <th>অ্যাকশন</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($sources)): ?>
                        <?php foreach($sources as $row): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($row['source_id']); ?></td>
                                <td><?php echo htmlspecialchars($row['source_name']); ?></td>
                                <td>
                                    <?php 
                                        echo $row['is_active'] 
                                            ? '<span class="status-active">সক্রিয়</span>' 
                                            : '<span class="status-inactive">নিষ্ক্রিয়</span>'; 
                                    ?>
                                </td>
                                <td class="actions">
                                    <a href="edit_source.php?id=<?php echo htmlspecialchars($row['source_id']); ?>" class="edit-btn" title="সম্পাদনা">
                                        <i class="fas fa-edit"></i> সম্পাদনা
                                    </a>
                                    <form method="POST" action="" style="display:inline-block;">
                                        <input type="hidden" name="delete_source_id" value="<?php echo htmlspecialchars($row['source_id']); ?>">
                                        <button type="submit" class="delete-btn" onclick="return confirm('আপনি কি নিশ্চিত যে এই উৎসটি মুছে ফেলতে চান? এটি আয়ের রিপোর্টে সমস্যা করতে পারে।')">
                                            <i class="fas fa-trash-alt"></i> মুছে ফেলুন
                                        </button>
                                    </form>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="4" style="text-align: center; color: #7f8c8d; font-style: italic;">কোনো আয়ের উৎস পাওয়া যায়নি।</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
</body>
</html>