<?php
session_start();
include '../../includes/db_connection.php'; 

if (!isset($_SESSION['user_id'])) {
    header("Location: /school_management/public/index.php");
    exit();
}

// ডিফল্টভাবে এই মাসের রিপোর্ট
$current_month = date('Y-m');
$filter_month = isset($_GET['month']) ? $_GET['month'] : $current_month;

// রিপোর্টের জন্য ডেটা সংগ্রহ
$sql = "SELECT income_source, SUM(amount) as total_amount 
        FROM other_incomes
        WHERE DATE_FORMAT(income_date, '%Y-%m') = ?
        GROUP BY income_source
        ORDER BY total_amount DESC";

$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $filter_month);
$stmt->execute();
$result = $stmt->get_result();
$report_data = $result->fetch_all(MYSQLI_ASSOC);
$stmt->close();

// মাসের মোট আয়
$total_income_sql = "SELECT SUM(amount) as grand_total 
                     FROM other_incomes
                     WHERE DATE_FORMAT(income_date, '%Y-%m') = ?";
$stmt_total = $conn->prepare($total_income_sql);
$stmt_total->bind_param("s", $filter_month);
$stmt_total->execute();
$total_result = $stmt_total->get_result();
$grand_total = $total_result->fetch_assoc()['grand_total'] ?? 0;
$stmt_total->close();

$conn->close();
?>

<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>আয়ের রিপোর্ট</title>
    <link rel="stylesheet" href="../../public/css/style.css">
    <style>
        .report-container { width: 700px; margin: 50px auto; padding: 20px; border: 1px solid #ddd; border-radius: 5px; background-color: #fff; }
        .report-summary { background-color: #c8e6c9; padding: 15px; margin-bottom: 20px; border-radius: 5px; text-align: center; }
        .report-summary h3 { margin: 0; color: #1b5e20; }
        .report-table th { background-color: #4caf50; color: white; }
        .filter-form { margin-bottom: 20px; padding: 10px; background-color: #f0f4c3; border-radius: 5px; }
    </style>
</head>
<body>
<div class="header">
    <h1>মিফতাহুন নাজাত মহিলা মাদরাসা</h1>
     <h1>নেয়ামতপুর,সদর,নোয়াখালী</h1>
      <div class="nav">
        <a href="/school_management/public/dashboard.php">ড্যাশবোর্ড</a>
        <a href="/school_management/public/students/students_list.php">শিক্ষার্থী</a>
        <a href="/school_management/public/teachers/teachers_list.php">শিক্ষক</a>
        <a href="/school_management/public/fees/fee_collection.php">ফি সংগ্রহ</a>
        <a href="/school_management/public/incomes/income_list.php">অন্যান্য আয়</a>
        <a href="/school_management/public/fees/monthly_fee_summary.php">মাসিক রিপোর্ট</a>
        <a href="/school_management/public/classes/classes_list.php">শ্রেণি</a>
        <a href="/school_management/public/subjects/subjects_list.php">বিষয়</a>
        <a href="/school_management/public/exam_results/add_exam_result.php">পরীক্ষা</a>
        <a href="/school_management/public/exam_results/exam_report.php">পরীক্ষার রিপোর্ট</a>
        <a href="/school_management/public/attendance/record_attendance.php">উপস্থিতি</a>
        <a href="/school_management/public/attendance/attendance_report.php">উপস্থিতি রিপোর্ট</a>
        <a href="/school_management/public/change_password.php">পাসওয়ার্ড পরিবর্তন</a>
        <a href="/school_management/public/logout.php">লগআউট</a>
    </div>
    </div>
<div class="content">
    <div class="report-container">
        <h2>অন্যান্য আয়ের রিপোর্ট (<?php echo date('Y সালের F', strtotime($filter_month)); ?>)</h2>
        
        <div class="filter-form">
            <form method="GET" action="" style="display: flex; gap: 10px; align-items: center;">
                <label for="month">মাস নির্বাচন করুন:</label>
                <input type="month" id="month" name="month" value="<?php echo htmlspecialchars($filter_month); ?>" required>
                <button type="submit" class="button" style="background-color: #5d4037; padding: 8px 15px;">রিপোর্ট দেখুন</button>
                <a href="income_list.php" class="button" style="background-color: #795548; padding: 8px 15px; text-decoration: none;">তালিকায় ফিরে যান</a>
            </form>
        </div>

        <div class="report-summary">
            <h3>মোট আয়: <?php echo number_format($grand_total, 2); ?> টাকা</h3>
        </div>
        
        <?php if (!empty($report_data)): ?>
            <table class="report-table" width="100%" border="1" style="border-collapse: collapse;">
                <thead>
                    <tr>
                        <th>আয়ের উৎস</th>
                        <th>মোট সংগৃহীত পরিমাণ</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach($report_data as $row): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($row['income_source']); ?></td>
                            <td><?php echo number_format($row['total_amount'], 2); ?> টাকা</td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php else: ?>
            <p style="text-align: center; color: #757575;">এই মাসে কোনো আয়ের রেকর্ড পাওয়া যায়নি।</p>
        <?php endif; ?>
    </div>
</div>
</body>
</html>