<?php
session_start();
include '../../includes/db_connection.php'; 

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'Admin') {
    die("আপনার এই পাতা ব্যবহারের অনুমতি নেই।");
}

$source_id = $_GET['id'] ?? null;
$message = '';
$error = '';
$source_data = null;

if (!$source_id) {
    header("Location: income_sources_list.php");
    exit();
}

// 1. ফর্ম সাবমিট হলে ডেটা আপডেট করা
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $source_name = trim($_POST['source_name']);
    $is_active = isset($_POST['is_active']) ? 1 : 0;
    
    if (empty($source_name)) {
        $error = "উৎসের নাম লিখতে হবে।";
    } else {
        $sql = "UPDATE income_sources SET source_name = ?, is_active = ? WHERE source_id = ?";
        $stmt = $conn->prepare($sql);
        
        if ($stmt === false) {
             $error = "SQL প্রস্তুতে সমস্যা: " . $conn->error;
        } else {
            $stmt->bind_param("sii", $source_name, $is_active, $source_id);

            if ($stmt->execute()) {
                $message = "আয়ের উৎস সফলভাবে আপডেট করা হয়েছে!";
                // আপডেটের পর নতুন ডেটা আবার লোড করার জন্য ফ্ল্যাগ সেট করা
                $reload_data = true; 
            } else {
                if ($conn->errno == 1062) {
                    $error = "এই আয়ের উৎসটি (নাম) ইতিমধ্যেই ডাটাবেসে আছে।";
                } else {
                    $error = "রেকর্ড আপডেট করতে ব্যর্থ: " . $stmt->error;
                }
            }
            $stmt->close();
        }
    }
}

// 2. ফর্ম লোড করার জন্য বা আপডেট করার পর ডেটা ডাটাবেস থেকে আনা
if (empty($source_data) || isset($reload_data)) {
    $sql = "SELECT source_id, source_name, is_active FROM income_sources WHERE source_id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $source_id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows === 1) {
        $source_data = $result->fetch_assoc();
    } else {
        $error = "রেকর্ডটি খুঁজে পাওয়া যায়নি।";
        $source_data = false;
    }
    $stmt->close();
}

if ($source_data === false) {
    header("Location: income_sources_list.php");
    exit();
}

$conn->close();
?>

<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>উৎস সম্পাদনা</title>
    <link rel="stylesheet" href="../../public/css/style.css"> 
    <style>
        .form-container { width: 400px; margin: 50px auto; padding: 20px; border: 1px solid #ccc; border-radius: 5px; background-color: #f9f9f9; }
        .form-container label { display: block; margin-bottom: 5px; font-weight: bold; }
        .form-container input[type="text"] { width: 100%; padding: 10px; margin-bottom: 15px; border: 1px solid #ddd; border-radius: 4px; box-sizing: border-box; }
        .form-buttons button { background-color: #ff9800; color: white; padding: 10px 15px; border: none; border-radius: 4px; cursor: pointer; margin-right: 10px; }
        .form-buttons button:hover { background-color: #e68900; }
        .message-success { color: green; font-weight: bold; }
        .message-error { color: red; font-weight: bold; }
        .checkbox-group { display: flex; align-items: center; margin-bottom: 15px; }
        .checkbox-group input { margin-right: 10px; width: auto; }
    </style>
</head>
<body>
<div class="header">
    <h1>স্কুল ম্যানেজমেন্ট সিস্টেম</h1>
</div>
<div class="content">
    <div class="form-container">
        <h2>আয়ের উৎস সম্পাদনা (ID: <?php echo htmlspecialchars($source_id); ?>)</h2>
        <?php if ($message): ?><p class="message-success"><?php echo $message; ?></p><?php endif; ?>
        <?php if ($error): ?><p class="message-error"><?php echo $error; ?></p><?php endif; ?>

        <?php if ($source_data): ?>
        <form action="" method="POST">
            
            <label for="source_name">আয়ের উৎসের নাম:</label>
            <input type="text" id="source_name" name="source_name" required 
                   placeholder="যেমন: নতুন অনুদান ফান্ড" 
                   value="<?php echo htmlspecialchars($source_data['source_name']); ?>">
            
            <div class="checkbox-group">
                <input type="checkbox" id="is_active" name="is_active" <?php echo $source_data['is_active'] ? 'checked' : ''; ?>>
                <label for="is_active" style="margin-bottom: 0; font-weight: normal;">উৎসটি সক্রিয় রাখুন</label>
            </div>

            <div class="form-buttons">
                <button type="submit">আপডেট করুন</button>
                <a href="income_sources_list.php" class="button" style="background-color: #6c757d; color: white; text-decoration: none; padding: 10px 15px; border-radius: 4px;">বাতিল</a>
            </div>
        </form>
        <?php endif; ?>
    </div>
</div>
</body>
</html>