<?php
session_start();
include '../../includes/db_connection.php'; // db_connection পাথ ঠিক রাখুন

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'Admin') {
    die("আপনার এই পাতা ব্যবহারের অনুমতি নেই।");
}

$income_id = $_GET['id'] ?? null;
$message = '';
$error = '';
$income_data = null;

// 1. আইডি না থাকলে বাটন ক্লিক কাজ করবে না
if (!$income_id) {
    header("Location: income_list.php");
    exit();
}

// 2. ফর্ম সাবমিট হলে ডেটা আপডেট করা
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $income_source = $_POST['income_source'];
    $description = $_POST['description'];
    $amount = $_POST['amount'];
    $income_date = $_POST['income_date'];
    
    if (empty($income_source) || empty($amount) || empty($income_date)) {
        $error = "সব প্রয়োজনীয় ফিল্ড পূরণ করুন।";
    } else {
        $sql = "UPDATE other_incomes SET income_source = ?, description = ?, amount = ?, income_date = ? WHERE income_id = ?";
        $stmt = $conn->prepare($sql);
        
        if ($stmt === false) {
             $error = "SQL প্রস্তুতে সমস্যা: " . $conn->error;
        } else {
            // bind_param: sdsi (Source, Description, Amount, Date, ID)
            $stmt->bind_param("ssdsi", $income_source, $description, $amount, $income_date, $income_id);

            if ($stmt->execute()) {
                $message = "আয়ের রেকর্ড সফলভাবে আপডেট করা হয়েছে!";
                // আপডেটের পর নতুন ডেটা আবার লোড করার জন্য ফ্ল্যাগ সেট করা
                $reload_data = true; 
            } else {
                $error = "রেকর্ড আপডেট করতে ব্যর্থ: " . $stmt->error;
            }
            $stmt->close();
        }
    }
}

// 3. ফর্ম লোড করার জন্য ডেটা ডাটাবেস থেকে আনা
if (empty($income_data) || isset($reload_data)) {
    $sql = "SELECT income_id, income_source, description, amount, income_date FROM other_incomes WHERE income_id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $income_id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows === 1) {
        $income_data = $result->fetch_assoc();
    } else {
        $error = "রেকর্ডটি খুঁজে পাওয়া যায়নি।";
        $income_data = false;
    }
    $stmt->close();
}

// যদি রেকর্ড না পাওয়া যায়, তবে ইউজারকে লিস্ট পেজে ফেরত পাঠানো
if ($income_data === false) {
    header("Location: income_list.php");
    exit();
}

$conn->close();
?>

<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>আয় সম্পাদনা</title>
    <link rel="stylesheet" href="../../public/css/style.css"> 
    <style>
        .form-container { width: 400px; margin: 50px auto; padding: 20px; border: 1px solid #ccc; border-radius: 5px; background-color: #f9f9f9; }
        .form-container label { display: block; margin-bottom: 5px; font-weight: bold; }
        .form-container input[type="text"], .form-container input[type="number"], .form-container input[type="date"], .form-container textarea { width: 100%; padding: 10px; margin-bottom: 15px; border: 1px solid #ddd; border-radius: 4px; box-sizing: border-box; }
        .form-buttons button { background-color: #ff9800; color: white; padding: 10px 15px; border: none; border-radius: 4px; cursor: pointer; margin-right: 10px; }
        .form-buttons button:hover { background-color: #e68900; }
        .message-success { color: green; font-weight: bold; }
        .message-error { color: red; font-weight: bold; }
    </style>
</head>
<body>
<div class="header">
    <h1>স্কুল ম্যানেজমেন্ট সিস্টেম</h1>
    </div>
<div class="content">
    <div class="form-container">
        <h2>আয় সম্পাদনা (ID: <?php echo htmlspecialchars($income_id); ?>)</h2>
        <?php if ($message): ?>
            <p class="message-success"><?php echo $message; ?></p>
        <?php endif; ?>
        <?php if ($error): ?>
            <p class="message-error"><?php echo $error; ?></p>
        <?php endif; ?>

        <?php if ($income_data): ?>
        <form action="" method="POST">
            
            <label for="income_date">আয়ের তারিখ:</label>
            <input type="date" id="income_date" name="income_date" required 
                   value="<?php echo htmlspecialchars($income_data['income_date']); ?>">

            <label for="income_source">আয়ের উৎস:</label>
            <input type="text" id="income_source" name="income_source" required 
                   placeholder="যেমন: অনুদান, মাঠ ভাড়া" 
                   value="<?php echo htmlspecialchars($income_data['income_source']); ?>">

            <label for="amount">পরিমাণ (টাকা):</label>
            <input type="number" step="0.01" id="amount" name="amount" required 
                   value="<?php echo htmlspecialchars($income_data['amount']); ?>">
            
            <label for="description">বিস্তারিত বিবরণ:</label>
            <textarea id="description" name="description" rows="3"><?php echo htmlspecialchars($income_data['description']); ?></textarea>

            <div class="form-buttons">
                <button type="submit">আপডেট করুন</button>
                <a href="income_list.php" class="button" style="background-color: #6c757d; color: white; text-decoration: none; padding: 10px 15px; border-radius: 4px;">বাতিল</a>
            </div>
        </form>
        <?php endif; ?>
    </div>
</div>
</body>
</html>