<?php
session_start();
// ডেটাবেস সংযোগ পাথের সঠিকতা নিশ্চিত করুন
include '../../includes/db_connection.php'; 

// নিরাপত্তা যাচাই
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'Admin') {
    die("আপনার এই পাতা ব্যবহারের অনুমতি নেই।");
}

date_default_timezone_set('Asia/Dhaka');

// বাংলা সংখ্যায় রূপান্তর ফাংশন
function format_to_bangla_number($number) {
    $formatted_number = number_format($number, 0, '.', ','); 
    $english_digits = range(0, 9);
    $bangla_digits = array('০', '১', '২', '৩', '৪', '৫', '৬', '৭', '৮', '৯');
    return str_replace($english_digits, $bangla_digits, $formatted_number);
}

// ===========================================
// ১. মোট আয় গণনা
// ===========================================

// ফি থেকে মোট আয়
$fees_sql = "SELECT COALESCE(SUM(amount), 0) AS total_fees FROM fees";
$fees_result = $conn->query($fees_sql);
$total_fees = $fees_result->fetch_assoc()['total_fees'];

// অন্যান্য উৎস থেকে মোট আয়
$other_income_sql = "SELECT COALESCE(SUM(amount), 0) AS total_other_income FROM other_incomes";
$other_income_result = $conn->query($other_income_sql);
$total_other_income = $other_income_result->fetch_assoc()['total_other_income'];

$total_income = $total_fees + $total_other_income;


// ===========================================
// ২. মোট ব্যয় গণনা
// ===========================================
$expense_sql = "SELECT COALESCE(SUM(amount), 0) AS total_expense FROM expenses";
$expense_result = $conn->query($expense_sql);
$total_expense = $expense_result->fetch_assoc()['total_expense'];


// ===========================================
// ৩. বর্তমান ক্যাশ (নিট ফলাফল) গণনা
// ===========================================
$current_cash = $total_income - $total_expense;

// ডেটাবেস সংযোগ বন্ধ
$conn->close();

// আউটপুটের জন্য বাংলা ফরম্যাটে রূপান্তর
$total_income_bn = format_to_bangla_number($total_income);
$total_expense_bn = format_to_bangla_number($total_expense);
$current_cash_bn = format_to_bangla_number(abs($current_cash));
$current_cash_text = $current_cash >= 0 ? 'বর্তমান ক্যাশ (Cash in Hand)' : 'মোট ঘাটতি (Deficit)';
$current_cash_class = $current_cash >= 0 ? 'profit' : 'loss';

?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>বর্তমান ক্যাশ সারাংশ</title>
    <link rel="stylesheet" href="../../public/css/style.css"> 
    <style>
        .container { max-width: 700px; margin: 50px auto; padding: 30px; background-color: #fff; border-radius: 12px; box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1); }
        h2 { text-align: center; color: #333; margin-bottom: 25px; border-bottom: 2px solid #eee; padding-bottom: 10px; }
        .cash-summary { margin-top: 20px; }
        .summary-card { 
            display: flex; 
            justify-content: space-between; 
            padding: 15px 20px; 
            margin-bottom: 15px;
            border-radius: 8px;
            font-size: 1.1em;
            font-weight: bold;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.05);
        }
        .income-card { background-color: #e8f5e9; border-left: 5px solid #4CAF50; }
        .expense-card { background-color: #fce4ec; border-left: 5px solid #FF5722; }
        .cash-card { background-color: #e0f2f1; border-left: 5px solid #009688; font-size: 1.3em; padding: 20px; }
        .cash-card.loss { background-color: #ffebee; border-left-color: #b71c1c; }
        
        .amount { font-size: 1.2em; }
        .amount.profit { color: #004d40; }
        .amount.loss { color: #b71c1c; }

        /* Action Buttons */
        .action-buttons { text-align: center; margin-top: 30px; }
        .action-buttons button, .action-buttons a {
            padding: 10px 20px;
            margin: 0 8px;
            font-size: 1em;
            cursor: pointer;
            border: none;
            border-radius: 5px;
            text-decoration: none;
            display: inline-block;
            font-weight: bold;
        }
        .print-btn { background-color: #607d8b; color: white; }
        .print-btn:hover { background-color: #455a64; }
        .dashboard-btn { background-color: #007bff; color: white; }
        .dashboard-btn:hover { background-color: #0056b3; }

        /* Print Specific Styles */
        @media print {
            .header, .footer, .action-buttons { display: none; }
            .container { margin: 0; padding: 0; box-shadow: none; max-width: 100%; }
            .summary-card { background-color: #fff !important; color: #000 !important; border: 1px solid #ddd; -webkit-print-color-adjust: exact; print-color-adjust: exact; }
            .amount.profit, .amount.loss { color: #000 !important; }
        }
    </style>
</head>
<body>
<div class="header">
    <h1>সার্বিক ক্যাশ ফ্লো রিপোর্ট (সর্বকালীন)</h1>
</div>
<div class="content">
    <div class="container">
        <h2>আর্থিক সংক্ষিপ্ত বিবরণী</h2>

        <div class="action-buttons">
            <a href="/school_management/public/dashboard.php" class="dashboard-btn">
                🏠 ড্যাশবোর্ডে ফিরুন
            </a>
            <button class="print-btn" onclick="window.print()">
                🖨️ প্রিন্ট করুন
            </button>
        </div>
        
        <div class="cash-summary">
            
            <div class="summary-card income-card">
                <div>মোট আয়:</div>
                <div class="amount profit"><?php echo $total_income_bn; ?> ৳</div>
            </div>

            <div class="summary-card expense-card">
                <div>মোট ব্যয়:</div>
                <div class="amount loss"><?php echo $total_expense_bn; ?> ৳</div>
            </div>

            <hr style="border-top: 2px solid #333; margin: 25px 0;">

            <div class="summary-card cash-card <?php echo $current_cash_class; ?>">
                <div><?php echo $current_cash_text; ?>:</div>
                <div class="amount <?php echo $current_cash_class; ?>"><?php echo $current_cash_bn; ?> ৳</div>
            </div>
            
        </div>
        
    </div>
</div>
<div class="footer">
    <p>&copy; <?php echo date("Y"); ?> স্কুল ম্যানেজমেন্ট সিস্টেম। সর্বস্বত্ব সংরক্ষিত।</p>
</div>
</body>
</html>