<?php
session_start();
// পাথের সঠিকতা নিশ্চিত করুন
include '../../includes/db_connection.php'; 

// শুধুমাত্র অ্যাডমিনই এই পাতা ব্যবহার করতে পারবে
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'Admin') {
    die("আপনার এই পাতা ব্যবহারের অনুমতি নেই।");
}

$message = '';
$error = '';

// === ভ্যারিয়েবল ইনিশিয়ালাইজেশন ===
$income_source_id = ''; 
$description = '';
$amount = '';
$income_date = date('Y-m-d'); // ডিফল্ট হিসাবে আজকের তারিখ
$memo_no = ''; // নতুন যুক্ত করা হলো

// 1. ডাটাবেস থেকে আয়ের উৎসের তালিকা লোড করা
$sources_sql = "SELECT source_id, source_name FROM income_sources WHERE is_active = TRUE ORDER BY source_name ASC";
$sources_result = $conn->query($sources_sql);
$income_sources = [];
if ($sources_result && $sources_result->num_rows > 0) {
    while ($row = $sources_result->fetch_assoc()) {
        $income_sources[] = $row;
    }
}


// 2. ফর্ম সাবমিট হ্যান্ডেল করা
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // পোস্ট করা মানগুলো গ্রহণ করা
    $income_source_id = $_POST['income_source_id'] ?? '';
    $description = trim($_POST['description'] ?? '');
    $amount = $_POST['amount'] ?? 0;
    $income_date = $_POST['income_date'] ?? date('Y-m-d');
    $memo_no = trim($_POST['memo_no'] ?? ''); // নতুন মেমো নং গ্রহণ করা হলো
    $received_by = $_SESSION['user_id']; 

    // ইনপুট ভ্যালিডেশন
    if (empty($income_source_id) || empty($amount) || $amount <= 0 || empty($income_date)) {
        $error = "সব প্রয়োজনীয় ফিল্ড (উৎস, পরিমাণ, তারিখ) সঠিকভাবে পূরণ করুন।";
    } else {
        
        // উৎসের আইডি থেকে উৎসের নাম বের করা
        $selected_source_name = '';
        foreach($income_sources as $source) {
            if ((string)$source['source_id'] === $income_source_id) {
                $selected_source_name = $source['source_name'];
                break;
            }
        }
        
        if (empty($selected_source_name)) {
            $error = "অবৈধ আয়ের উৎস নির্বাচন করা হয়েছে।";
        } else {
            // other_incomes টেবিলে ডেটা INSERT করা
            // memo_no কলামটি SQL কোয়েরিতে income_date এর পরে আসছে।
            $sql = "INSERT INTO other_incomes (income_source, description, amount, income_date, memo_no, received_by) VALUES (?, ?, ?, ?, ?, ?)";
            $stmt = $conn->prepare($sql);
            
            if ($stmt === false) {
                 $error = "SQL প্রস্তুতে সমস্যা: " . $conn->error;
            } else {
                // bind_param: s (Source Name), s (Description), d (Amount), s (Date), s (Memo No), i (User ID)
                // মেমো নং (s) এবং রিসিভড বাই (i) এর অবস্থান SQL কলামের ক্রম অনুযায়ী সেট করা হয়েছে।
                // ভুল এড়াতে, দয়া করে নিশ্চিত করুন যে কলামের ক্রমটি INSERT স্টেটমেন্টের মতোই থাকে।
                $stmt->bind_param("ssdsis", $selected_source_name, $description, $amount, $income_date, $memo_no, $received_by);

                if ($stmt->execute()) {
                    $message = "নতুন আয় সফলভাবে যুক্ত করা হয়েছে! (উৎস: " . htmlspecialchars($selected_source_name) . ")";
                    
                    // সফল সাবমিটের পর ফর্ম রিসেট করার জন্য ভ্যারিয়েবল খালি করা
                    $income_source_id = ''; 
                    $description = '';
                    $amount = '';
                    $income_date = date('Y-m-d');
                    $memo_no = ''; // নতুন ভ্যারিয়েবল রিসেট করা হলো
                } else {
                    $error = "আয় যুক্ত করতে ব্যর্থ: " . $stmt->error;
                }
                $stmt->close();
            }
        }
    }
}

// যদি db_connection বন্ধ না হয়ে থাকে তবে এখানে বন্ধ করা যেতে পারে, যদিও ফর্ম সাবমিটের ক্ষেত্রে উপরেই বন্ধ করা হয়েছে
if (isset($conn) && $conn->ping()) {
    $conn->close();
}

?>

<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>নতুন অন্যান্য আয় যুক্ত করুন</title>
    <link rel="stylesheet" href="../../public/css/style.css"> 
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        /* উন্নত ডিজাইন */
        .content {
            padding: 20px;
        }
        .form-container { 
            width: 100%; 
            max-width: 500px; 
            margin: 30px auto; 
            padding: 30px; 
            border: 1px solid #e0e0e0; 
            border-radius: 8px; 
            background-color: #ffffff; 
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1); 
        }
        .form-container h2 {
            text-align: center;
            color: #34495e;
            margin-bottom: 25px;
            border-bottom: 2px solid #3498db;
            padding-bottom: 10px;
        }
        .form-container label { 
            display: block; 
            margin-bottom: 5px; 
            font-weight: bold; 
            color: #333;
            font-size: 14px;
        }
        .form-container input[type="text"], 
        .form-container input[type="number"], 
        .form-container input[type="date"], 
        .form-container textarea, 
        .form-container select { 
            width: 100%; 
            padding: 12px; 
            margin-bottom: 20px; 
            border: 1px solid #ccc; 
            border-radius: 6px; 
            box-sizing: border-box; 
            font-size: 16px;
            transition: border-color 0.3s;
        }
        .form-container input:focus, .form-container select:focus, .form-container textarea:focus {
            border-color: #3498db;
            outline: none;
        }

        /* বাটন স্টাইল */
        .form-buttons { 
            display: flex; 
            flex-wrap: wrap; 
            justify-content: space-between; 
            gap: 10px; 
            margin-top: 30px; 
        }
        .form-buttons button, .form-buttons a.button { 
            flex-grow: 1; 
            text-align: center; 
            padding: 12px 15px; 
            border: none; 
            border-radius: 6px; 
            cursor: pointer; 
            font-weight: bold;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            gap: 5px;
            transition: background-color 0.3s;
        }
        .form-buttons button { 
            background-color: #2ecc71; 
            color: white; 
        }
        .form-buttons button:hover { 
            background-color: #27ae60; 
        }
        .form-buttons a.button.source-manager {
            background-color: #9b59b6; 
            color: white; 
        }
        .form-buttons a.button.source-manager:hover {
            background-color: #8e44ad;
        }
        .form-buttons a.button.income-list {
            background-color: #3498db; 
            color: white; 
        }
        .form-buttons a.button.income-list:hover {
            background-color: #2980b9;
        }

        /* মেসেজ স্টাইল */
        .message-success { 
            color: #27ae60; 
            background-color: #e8f5e9; 
            padding: 10px; 
            border: 1px solid #a5d6a7; 
            border-radius: 4px; 
            margin-bottom: 15px; 
            text-align: center;
        }
        .message-error { 
            color: #c0392b; 
            background-color: #fbecec; 
            padding: 10px; 
            border: 1px solid #e57373; 
            border-radius: 4px; 
            margin-bottom: 15px; 
            text-align: center;
        }
        
        /* ব্যাক বাটন */
        .back-button {
            position: absolute;
            top: 15px;
            left: 20px;
            background-color: #34495e;
            color: white;
            padding: 8px 15px;
            border-radius: 4px;
            text-decoration: none;
            font-weight: bold;
            display: inline-flex;
            align-items: center;
            gap: 5px;
            transition: background-color 0.3s;
        }
        .back-button:hover {
            background-color: #2c3e50;
        }
    </style>
</head>
<body>
<div class="header">
    <h1>স্কুল ম্যানেজমেন্ট সিস্টেম</h1>
</div>

<a href="../../public/dashboard.php" class="back-button"><i class="fas fa-arrow-left"></i> ড্যাশবোর্ড</a>

<div class="content">
    <div class="form-container">
        <h2><i class="fas fa-plus-circle"></i> নতুন অন্যান্য আয় যুক্ত করুন</h2>
        
        <?php if ($message): ?>
            <p class="message-success"><i class="fas fa-check-circle"></i> <?php echo $message; ?></p>
        <?php endif; ?>
        
        <?php if ($error): ?>
            <p class="message-error"><i class="fas fa-exclamation-triangle"></i> <?php echo $error; ?></p>
        <?php endif; ?>

        <form action="" method="POST">
            
            <label for="income_date">আয়ের তারিখ:</label>
            <input type="date" id="income_date" name="income_date" required value="<?php echo htmlspecialchars($income_date); ?>">
            
            <label for="memo_no">মেমো নং (ঐচ্ছিক):</label>
            <input type="text" id="memo_no" name="memo_no" maxlength="50" placeholder="ম্যানুয়ালি মেমো বা রসিদ নং লিখুন" value="<?php echo htmlspecialchars($memo_no); ?>">


            <label for="income_source_id">আয়ের উৎস নির্বাচন করুন:</label>
            <select id="income_source_id" name="income_source_id" required>
                <option value="">-- উৎস নির্বাচন করুন --</option>
                <?php if (!empty($income_sources)): ?>
                    <?php foreach($income_sources as $source): ?>
                        <option value="<?php echo htmlspecialchars($source['source_id']); ?>" 
                                <?php echo ((string)$income_source_id === (string)$source['source_id']) ? 'selected' : ''; ?>>
                            <?php echo htmlspecialchars($source['source_name']); ?>
                        </option>
                    <?php endforeach; ?>
                <?php else: ?>
                    <option value="" disabled>কোনো সক্রিয় উৎস পাওয়া যায়নি।</option>
                <?php endif; ?>
            </select>

            <label for="amount">পরিমাণ (টাকা):</label>
            <input type="number" step="0.01" id="amount" name="amount" required min="1" placeholder="যেমন: ৫০০০" value="<?php echo isset($amount) && $amount > 0 ? htmlspecialchars($amount) : ''; ?>">
            
            <label for="description">বিস্তারিত বিবরণ (ঐচ্ছিক):</label>
            <textarea id="description" name="description" rows="3" placeholder="আয়ের কারণ বা বিস্তারিত লিখুন..."><?php echo htmlspecialchars($description); ?></textarea>

            <div class="form-buttons">
                <button type="submit"><i class="fas fa-save"></i> আয় সেভ করুন</button>
                
                <a href="income_sources_list.php" class="button source-manager"><i class="fas fa-wrench"></i> উৎস পরিচালনা</a>
                
                <a href="income_list.php" class="button income-list"><i class="fas fa-list-alt"></i> আয়ের তালিকা</a>
            </div>
        </form>
    </div>
</div>
<div class="footer">
    <p>&copy; <?php echo date("Y"); ?> স্কুল ম্যানেজমেন্ট সিস্টেম। সর্বস্বত্ব সংরক্ষিত।</p>
</div>
</body>
</html>