<?php
// আপনার ডেটাবেস সংযোগ ফাইল
include '../../includes/db_connection.php'; 

// AJAX অনুরোধ থেকে student_id এবং print_mode গ্রহণ করা
$student_id = isset($_GET['student_id']) ? intval($_GET['student_id']) : 0;
// 'yes' হলে প্রিন্ট মোড, অন্যথায় 'modal' বা ডিফল্ট মোড
$print_mode = isset($_GET['print_mode']) && $_GET['print_mode'] === 'yes'; 

if ($student_id <= 0 || !$conn) {
    if ($print_mode) {
        echo "<html><body><p style='color:red;'>অকার্যকর শিক্ষার্থী আইডি অথবা ডাটাবেস সংযোগ ব্যর্থ।</p></body></html>";
    } else {
        echo "<p style='color:red; text-align:center;'>অকার্যকর শিক্ষার্থী আইডি অথবা ডাটাবেস সংযোগ ব্যর্থ।</p>";
    }
    exit;
}

// =========================================================================
// ১. ডেটাবেস কোয়েরি 
// =========================================================================

// শিক্ষার্থীর তথ্য আনা (students এবং classes টেবিল JOIN করা হলো)
$student_info_sql = "
    SELECT 
        s.first_name, 
        s.last_name, 
        s.father_name, 
        s.class_roll,  
        s.village, 
        s.upazila, 
        s.district,
        s.fixed_fee,       
        c.class_name       
    FROM students s
    LEFT JOIN classes c ON s.class_id = c.class_id
    WHERE s.student_id = ?
";

$student_info_stmt = $conn->prepare($student_info_sql);
$student_info_stmt->bind_param("i", $student_id);
$student_info_stmt->execute();
$student_info_result = $student_info_stmt->get_result();
$student_info = $student_info_result->fetch_assoc();
$student_info_stmt->close();


// ফি-এর তথ্য আনা (fees এবং income_categories টেবিল JOIN করা হলো)
$fee_details_sql = "
    SELECT 
        f.amount, 
        f.payment_date, 
        f.payment_method, 
        f.memo_no,
        f.fee_month,         
        ic.category_name 
    FROM fees f
    LEFT JOIN income_categories ic ON f.category_id = ic.category_id
    WHERE f.student_id = ?
    ORDER BY f.payment_date DESC
";

$fee_details_stmt = $conn->prepare($fee_details_sql);
$fee_details_stmt->bind_param("i", $student_id);
$fee_details_stmt->execute();
$fee_details_result = $fee_details_stmt->get_result();


// =========================================================================
// ২. ডেটা প্রক্রিয়াকরণ ও বাংলা মাসের নাম
// =========================================================================

$month_names_bn = [
    1 => 'জানুয়ারি', 2 => 'ফেব্রুয়ারি', 3 => 'মার্চ', 4 => 'এপ্রিল', 
    5 => 'মে', 6 => 'জুন', 7 => 'জুলাই', 8 => 'আগস্ট', 
    9 => 'সেপ্টেম্বর', 10 => 'অক্টোবর', 11 => 'নভেম্বর', 12 => 'ডিসেম্বর'
];

if ($student_info) {
    $student_full_name = htmlspecialchars($student_info['first_name'] . ' ' . $student_info['last_name']);
    $full_address = htmlspecialchars($student_info['village'] . ', ' . $student_info['upazila'] . ', ' . $student_info['district']);
    $student_class_roll = htmlspecialchars($student_info['class_roll']);
    $student_class_name = htmlspecialchars($student_info['class_name']);
} else {
    // শিক্ষার্থী তথ্য না পেলে ডিফল্ট সেট করা
    $student_full_name = 'অজানা শিক্ষার্থী';
    $full_address = 'N/A';
    $student_class_roll = 'N/A';
    $student_class_name = 'N/A';
    $student_info['father_name'] = 'N/A';
    $student_info['fixed_fee'] = 0;
}


// =========================================================================
// ৩. HTML আউটপুট তৈরি (প্রিন্ট মোড অনুযায়ী ভিন্ন আউটপুট)
// =========================================================================

// মাসের নাম এবং বছরকে (যদি মাসিক/আবাসিক ফি হয়) বাংলায় রূপান্তর করার ফাংশন
function get_bengali_month_display($row, $month_names_bn) {
    $month_display = '---'; 
    $category_name = htmlspecialchars($row['category_name'] ?? 'অন্যান্য ফি');
    $fee_month_db = $row['fee_month'];

    // ক্যাটাগরির নামে 'মাসিক' বা 'আবাসিক' আছে কিনা তা চেক করা
    $is_monthly_or_residential = (
        strpos($category_name, 'মাসিক') !== false ||
        strpos($category_name, 'আবাসিক') !== false
    );
    
    if ($is_monthly_or_residential && !empty($fee_month_db) && $fee_month_db !== '0000-00-00') {
        // ডেট স্ট্রিং থেকে শুধু মাসের সংখ্যা নেওয়া
        $month_number = (int)date('n', strtotime($fee_month_db));
        $year = date('Y', strtotime($fee_month_db));
        
        if ($month_number >= 1 && $month_number <= 12) {
            // বাংলা মাসের নাম + বছর
            $month_display = $month_names_bn[$month_number] . " ({$year})";
        }
    } 
    return $month_display;
}


if ($print_mode) {
    // ------------------------------------
    // প্রিন্ট মোড HTML (নতুন উইন্ডো)
    // ------------------------------------
    ?>
    <!DOCTYPE html>
    <html lang="bn">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title><?php echo $student_full_name; ?> - ফি বিবরণী</title>
        <style>
            /* বাংলা ফন্টের জন্য উপযুক্ত ফন্ট ব্যবহার করা উচিত */
            body { font-family: Arial, sans-serif; margin: 0; padding: 20px; font-size: 14px; }
            .print-container { width: 100%; max-width: 800px; margin: 0 auto; border: 1px solid #000; padding: 20px; box-shadow: 0 0 5px rgba(0,0,0,0.2); }
            .header-info { text-align: center; margin-bottom: 20px; }
            .header-info h1 { margin: 0; font-size: 20px; color: #34495e; }
            .header-info h2 { margin-top: 5px; font-size: 16px; border-bottom: 2px solid #34495e; padding-bottom: 5px; display: inline-block;}
            .header-info p { margin: 2px 0; font-size: 12px; }
            
            .student-details { border: 1px solid #ccc; padding: 10px; margin-bottom: 20px; background-color: #f9f9f9; }
            .details-table { width: 100%; border-collapse: collapse; }
            .details-table td { padding: 5px; border: none; font-size: 13px; }
            .details-table td:nth-child(odd) { font-weight: bold; width: 20%; }
            .details-table td:nth-child(even) { width: 30%; }
            
            h3 { margin-top: 20px; margin-bottom: 10px; font-size: 15px; border-bottom: 1px solid #ccc; padding-bottom: 5px; }

            .fee-table { width: 100%; border-collapse: collapse; margin-top: 10px; }
            .fee-table th, .fee-table td { border: 1px solid #ddd; padding: 8px; text-align: left; font-size: 12px; }
            .fee-table th { background-color: #e6e6e6; text-align: center; }
            .total-row td { font-weight: bold; background-color: #d9e6ff; border-top: 2px solid #000; font-size: 14px; }
            .text-right { text-align: right; }
            .text-center { text-align: center; }
            
            .signature-area { margin-top: 50px; display: flex; justify-content: space-between; font-size: 13px; }
            .signature-area div { width: 30%; border-top: 1px solid #000; text-align: center; padding-top: 5px; }
            
            @media print {
                body { padding: 0; margin: 0; font-size: 10pt; }
                .print-container { border: none !important; box-shadow: none !important; }
                .details-table td, .fee-table th, .fee-table td { font-size: 9pt; }
                .total-row td { font-size: 10pt; }
            }
        </style>
    </head>
    <body>
        <div class="print-container">
            <div class="header-info">
                <h1>মিফতাহুন নাজাত মহিলা মাদরাসা</h1>
                <p>নেয়ামতপুর, সদর, নোয়াখালী।</p>
                <h2>শিক্ষার্থী ফি পরিশোধের বিবরণী</h2>
            </div>

            <div class="student-details">
                <table class="details-table">
                    <tr>
                        <td>শিক্ষার্থীর নাম:</td><td><?php echo $student_full_name; ?> (ID: <?php echo $student_id; ?>)</td>
                        <td>পিতার নাম:</td><td><?php echo htmlspecialchars($student_info['father_name']); ?></td>
                    </tr>
                    <tr>
                        <td>শ্রেণি:</td><td><?php echo $student_class_name; ?> (রোল: <?php echo $student_class_roll; ?>)</td>
                        <td>ধার্য্যকৃত ফি (মাসিক):</td><td><?php echo number_format($student_info['fixed_fee'], 0); ?> ৳</td>
                    </tr>
                    <tr>
                        <td>ঠিকানা:</td><td colspan="3"><?php echo $full_address; ?></td>
                    </tr>
                </table>
            </div>

            <h3>পরিশোধের ইতিহাস</h3>

            <?php if ($fee_details_result->num_rows > 0): ?>
                <table class="fee-table">
                    <thead>
                        <tr>
                            <th class="text-center">মেমো নং</th>
                            <th style="width: 30%;">ফি-এর বিবরণ (ক্যাটাগরি)</th>
                            <th class="text-center">পরিশোধের মাস</th>
                            <th class="text-center">পরিশোদের তারিখ</th>
                            <th class="text-center">পরিশোদের মাধ্যম</th>
                            <th class="text-right">পরিশোধিত অর্থ (৳)</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $total_paid = 0; ?>
                        <?php while ($row = $fee_details_result->fetch_assoc()): 
                            $total_paid += $row['amount'];
                            $month_display = get_bengali_month_display($row, $month_names_bn);
                        ?>
                            <tr>
                                <td class="text-center"><?php echo htmlspecialchars($row['memo_no'] ?? 'N/A'); ?></td>
                                <td><?php echo htmlspecialchars($row['category_name'] ?? 'অন্যান্য ফি'); ?></td>
                                <td class="text-center"><?php echo $month_display; ?></td>
                                <td class="text-center"><?php echo date('d-m-Y', strtotime($row['payment_date'])); ?></td>
                                <td class="text-center"><?php echo htmlspecialchars($row['payment_method']); ?></td>
                                <td class="text-right"><?php echo htmlspecialchars(number_format($row['amount'], 0)); ?></td>
                            </tr>
                        <?php endwhile; ?>
                        
                        <tr class="total-row">
                            <td colspan="5" class="text-right">সর্বমোট পরিশোধ:</td>
                            <td class="text-right"><?php echo number_format($total_paid, 0); ?> ৳</td>
                        </tr>
                    </tbody>
                </table>
            <?php else: ?>
                <p style='text-align:center; font-weight:bold;'>এই শিক্ষার্থীর কোনো ফি-এর তথ্য পাওয়া যায়নি।</p>
            <?php endif; ?>

            <div class="signature-area">
                <div>শিক্ষার্থী/অভিভাবকের স্বাক্ষর</div>
                <div>অ্যাকাউন্টেন্ট-এর স্বাক্ষর</div>
                <div>প্রধান শিক্ষক/অধ্যক্ষের স্বাক্ষর</div>
            </div>
            
            <p style="text-align: right; margin-top: 20px; font-size: 11px;">প্রিন্ট করা হয়েছে: <?php echo date('d-m-Y, h:i A'); ?></p>

        </div>
    </body>
    </html>

    <?php
} else {
    // ------------------------------------
    // মোডাল মোড HTML (AJAX response)
    // ------------------------------------

    // শিক্ষার্থীর প্রাথমিক তথ্য
    if ($student_info) {
        // স্টাইল এখানে ইনলাইন রাখা হলো যেন মোডাল ঠিকমতো কাজ করে
        echo "<style>
            .student-meta-table td { padding: 5px; font-size: 14px; }
            .student-meta-table td:first-child { font-weight: bold; width: 30%; }
            .fee-details-table th, .fee-details-table td { font-size: 13px; padding: 5px; text-align: left; border: 1px solid #ddd; }
            .fee-details-table th { background-color: #f2f2f2; text-align: center; }
            .fee-details-table .text-right { text-align: right; }
        </style>";
        
        echo "<table class='student-meta-table' style='width:100%; margin-bottom: 15px;'>";
        
        // প্রথম সার
        echo "<tr>";
        echo "<td>শ্রেণি:</td><td>" . $student_class_name . " (রোল: " . $student_class_roll . ")</td>";
        echo "<td>পিতার নাম:</td><td>" . htmlspecialchars($student_info['father_name']) . "</td>";
        echo "</tr>";
        
        // দ্বিতীয় সার
        echo "<tr>";
        echo "<td>ধার্য্যকৃত ফি:</td><td>" . number_format($student_info['fixed_fee'], 0) . " ৳ (মাসিক)</td>";
        echo "<td>ঠিকানা:</td><td>" . $full_address . "</td>";
        echo "</tr>";
        
        echo "</table>";
    }

    // ফি পরিশোধের বিবরণ
    echo "<h4 style='margin-top: 15px; border-top: 1px solid #ccc; padding-top: 10px;'>পরিশোধের ইতিহাস:</h4>";
    
    if ($fee_details_result->num_rows > 0) {
        $total_paid = 0;
        
        echo "<table class='fee-details-table' style='width:100%; border-collapse: collapse; margin-top: 10px;'>";
        echo "<thead><tr>
                <th style='width:10%;'>মেমো নং</th>
                <th style='width:30%;'>ফি-এর বিবরণ (ক্যাটাগরি)</th>
                <th style='width:15%;'>পরিশোধের মাস</th> 
                <th style='width:15%;'>পরিশোদের তারিখ</th>
                <th style='width:15%;'>পরিশোদের মাধ্যম</th>
                <th style='width:15%;' class='text-right'>পরিশোধিত অর্থ (৳)</th>
              </tr></thead>";
        echo "<tbody>";

        while ($row = $fee_details_result->fetch_assoc()) {
            $total_paid += $row['amount'];
            $month_display = get_bengali_month_display($row, $month_names_bn);

            echo "<tr>";
            echo "<td style='text-align:center;'>" . htmlspecialchars($row['memo_no'] ?? 'N/A') . "</td>";
            echo "<td>" . htmlspecialchars($row['category_name'] ?? 'অন্যান্য ফি') . "</td>";
            echo "<td style='text-align:center;'>" . $month_display . "</td>";
            echo "<td style='text-align:center;'>" . date('d-m-Y', strtotime($row['payment_date'])) . "</td>";
            echo "<td style='text-align:center;'>" . htmlspecialchars($row['payment_method']) . "</td>";
            echo "<td class='text-right'>" . htmlspecialchars(number_format($row['amount'], 0)) . "</td>";
            echo "</tr>";
        }
        
        // মোট পরিমাণের সার
        echo "<tr>
                <td colspan='5' style='text-align:right; font-weight:bold; background-color:#e0e7ff;'>সর্বমোট পরিশোধ:</td>
                <td class='text-right' style='font-weight:bold; background-color:#e0e7ff;'>" . number_format($total_paid, 0) . " ৳</td>
              </tr>";

        echo "</tbody></table>";
        
        // প্রিন্ট বাটন (মোডালের ভেতরে থাকবে)
        echo "<div style='text-align:center; margin-top: 20px;'>
                <button id='printFeeBtn' style='padding: 10px 20px; background-color: #28a745; color: white; border: none; border-radius: 5px; cursor: pointer; font-size: 14px;'>
                    <i class='fas fa-print'></i> বিবরণ প্রিন্ট করুন 
                </button>
              </div>";

        
    } else {
        echo "<p style='text-align:center; font-weight:bold;'>এই শিক্ষার্থীর কোনো ফি-এর তথ্য পাওয়া যায়নি।</p>";
    }
}

// =========================================================================
// ৪. সংযোগ বন্ধ করা
// =========================================================================
if (isset($conn) && $conn->ping()) {
    $conn->close();
}
?>