<?php
session_start();
include '../../includes/db_connection.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'Admin') {
    die("You do not have permission to perform this action.");
}

$fee_id = isset($_GET['id']) ? $_GET['id'] : null;

if ($fee_id) {
    $sql = "DELETE FROM fees WHERE fee_id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $fee_id);

    if ($stmt->execute()) {
        header("Location: fee_collection.php");
        exit();
    } else {
        echo "Error: " . $stmt->error;
    }
    $stmt->close();
} else {
    echo "No fee ID provided.";
}

$conn->close();
?>