<?php
session_start();
include '../../includes/db_connection.php'; 

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'Admin') {
    die("আপনার এই পাতা ব্যবহারের অনুমতি নেই।");
}

$message = '';
$error = '';

// নতুন খাত যোগ করার লজিক
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['add_category'])) {
    $category_name = trim($_POST['category_name']);
    $description = trim($_POST['description'] ?? '');

    if (empty($category_name)) {
        $error = "ব্যয়ের খাতের নাম অবশ্যই দিতে হবে।";
    } else {
        $sql = "INSERT INTO expense_categories (category_name, description) VALUES (?, ?)";
        $stmt = $conn->prepare($sql);
        if ($stmt) {
            $stmt->bind_param("ss", $category_name, $description);
            if ($stmt->execute()) {
                $message = "নতুন ব্যয় খাত সফলভাবে যুক্ত করা হয়েছে।";
            } else {
                $error = "ত্রুটি: ব্যয় খাত যুক্ত করা যায়নি। (সম্ভবত নাম ইতোমধ্যে বিদ্যমান)";
            }
            $stmt->close();
        } else {
            $error = "SQL প্রস্তুতিতে ত্রুটি: " . $conn->error;
        }
    }
}

// খাতের তালিকা লোড করা
$categories_sql = "SELECT * FROM expense_categories ORDER BY category_name ASC";
$categories_result = $conn->query($categories_sql);
$categories = [];
if ($categories_result && $categories_result->num_rows > 0) {
    while ($row = $categories_result->fetch_assoc()) {
        $categories[] = $row;
    }
}
$conn->close();
?>

<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ব্যয়ের খাত পরিচালনা</title>
    <link rel="stylesheet" href="../../public/css/style.css"> 
    <style>
        .container { max-width: 800px; margin: 50px auto; padding: 20px; background-color: #fff; border-radius: 8px; box-shadow: 0 0 10px rgba(0, 0, 0, 0.1); }
        .add-form, .list-table { margin-top: 20px; padding: 15px; border: 1px solid #ccc; border-radius: 5px; }
        .list-table table { width: 100%; border-collapse: collapse; }
        .list-table th, .list-table td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        .message-success { color: green; font-weight: bold; }
        .message-error { color: red; font-weight: bold; }
        .action-link { margin-right: 10px; }
    </style>
</head>
<body>
<div class="header">
    <h1>ব্যয়ের খাত পরিচালনা</h1>
</div>
<div class="container">
    <a href="../dashboard.php" style="float: right; text-decoration: none; color: #007bff;">← ড্যাশবোর্ড</a>
    <h2>নতুন ব্যয় খাত যোগ করুন</h2>

    <?php if ($message): ?>
        <p class="message-success"><?php echo $message; ?></p>
    <?php endif; ?>
    <?php if ($error): ?>
        <p class="message-error"><?php echo $error; ?></p>
    <?php endif; ?>

    <div class="add-form">
        <form action="" method="POST">
            <label for="category_name">খাতের নাম (যেমন: বেতন, বিদ্যুৎ বিল):</label>
            <input type="text" id="category_name" name="category_name" required>

            <label for="description">বিস্তারিত বিবরণ (ঐচ্ছিক):</label>
            <textarea id="description" name="description" rows="2"></textarea>
            
            <button type="submit" name="add_category" style="background-color: #007bff; color: white; padding: 10px 15px; border: none; border-radius: 4px; cursor: pointer; margin-top: 10px;">খাত যুক্ত করুন</button>
        </form>
    </div>

    <h2>বর্তমান ব্যয়ের খাত</h2>
    <div class="list-table">
        <table>
            <thead>
                <tr>
                    <th>ID</th>
                    <th>খাতের নাম</th>
                    <th>বিবরণ</th>
                    <th>অবস্থা</th>
                    <th>অ্যাকশন</th>
                </tr>
            </thead>
            <tbody>
                <?php if (!empty($categories)): ?>
                    <?php foreach ($categories as $cat): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($cat['category_id']); ?></td>
                            <td><?php echo htmlspecialchars($cat['category_name']); ?></td>
                            <td><?php echo htmlspecialchars($cat['description']); ?></td>
                            <td><?php echo $cat['is_active'] ? 'সক্রিয়' : 'নিষ্ক্রিয়'; ?></td>
                            <td>
                                <a href="edit_expense_category.php?id=<?php echo $cat['category_id']; ?>" class="action-link">সম্পাদনা</a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr><td colspan="5">কোনো ব্যয়ের খাত যুক্ত করা হয়নি।</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>
</body>
</html>