<?php
session_start();
include '../../includes/db_connection.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: /school_management/public/index.php");
    exit();
}

if (!isset($_GET['id'])) {
    die("কোনো ফলাফল আইডি সরবরাহ করা হয়নি।");
}

$result_id = $_GET['id'];
$message = '';
$error = '';

// Handle form submission for updating exam result
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $student_id = $_POST['student_id'];
    $subject_id = $_POST['subject_id'];
    $exam_id = $_POST['exam_id'];
    $marks = $_POST['marks'];

    // Removed 'grade' from the UPDATE query and bind_param
    $sql = "UPDATE exam_results SET student_id=?, subject_id=?, exam_id=?, marks=? WHERE result_id=?";
    $stmt = $conn->prepare($sql);
    
    if ($stmt === false) {
        $error = "SQL কোয়েরি তৈরিতে সমস্যা: " . $conn->error;
    } else {
        $stmt->bind_param("iiidi", $student_id, $subject_id, $exam_id, $marks, $result_id);
        
        if ($stmt->execute()) {
            $message = "ফলাফল সফলভাবে আপডেট করা হয়েছে!";
        } else {
            $error = "ফলাফল আপডেটের সময় সমস্যা হয়েছে: " . $stmt->error;
        }
        $stmt->close();
    }
}

// Fetch existing exam result data to populate the form
// Removed 'er.grade' from the SELECT query
$sql_select = "SELECT er.*, s.class_id FROM exam_results er JOIN students s ON er.student_id = s.student_id WHERE er.result_id = ?";
$stmt_select = $conn->prepare($sql_select);
$stmt_select->bind_param("i", $result_id);
$stmt_select->execute();
$result_data = $stmt_select->get_result()->fetch_assoc();
$stmt_select->close();

if (!$result_data) {
    die("ফলাফলটি খুঁজে পাওয়া যায়নি।");
}

// Fetch lists for dropdowns
$classes_sql = "SELECT class_id, class_name FROM classes ORDER BY class_name";
$classes_result = $conn->query($classes_sql);

$students_sql = "SELECT student_id, CONCAT(first_name, ' ', last_name, ' (', class_roll, ')') AS student_name FROM students WHERE class_id = ? ORDER BY student_name";
$students_stmt = $conn->prepare($students_sql);
$students_stmt->bind_param("i", $result_data['class_id']);
$students_stmt->execute();
$students_result = $students_stmt->get_result();
$students_stmt->close();

$subjects_sql = "SELECT subject_id, subject_name FROM subjects ORDER BY subject_name";
$subjects_result = $conn->query($subjects_sql);

$exams_sql = "SELECT exam_id, exam_name FROM exams ORDER BY exam_name";
$exams_result = $conn->query($exams_sql);
?>

<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ফলাফল সম্পাদনা</title>
    <link rel="stylesheet" href="/school_management/public/css/style.css">
    <style>
        .form-container {
            width: 500px;
            margin: 20px auto;
            background-color: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        .form-container h2 {
            text-align: center;
            color: #333;
        }
        .form-group {
            margin-bottom: 15px;
        }
        .form-group label {
            display: block;
            margin-bottom: 5px;
            font-weight: bold;
        }
        .form-group select, .form-group input, .form-group textarea {
            width: 100%;
            padding: 8px;
            box-sizing: border-box;
            border: 1px solid #ccc;
            border-radius: 4px;
        }
        .form-buttons {
            text-align: center;
        }
        .form-buttons button, .form-buttons a {
            padding: 10px 20px;
            font-size: 16px;
            cursor: pointer;
            border: none;
            border-radius: 5px;
            color: white;
            background-color: #007bff;
            transition: background-color 0.3s;
            text-decoration: none;
            display: inline-block;
            margin: 0 5px;
        }
        .form-buttons button:hover, .form-buttons a:hover {
            background-color: #0056b3;
        }
        .message-success {
            color: green;
            text-align: center;
            font-weight: bold;
        }
        .message-error {
            color: red;
            text-align: center;
            font-weight: bold;
        }
    </style>
</head>
<body>
<div class="header">
    <h1>স্কুল ম্যানেজমেন্ট সিস্টেম</h1>
    <div class="nav">
        <a href="/school_management/public/dashboard.php">ড্যাশবোর্ড</a>
        <a href="/school_management/public/students/students_list.php">শিক্ষার্থী</a>
        <a href="/school_management/public/teachers/teachers_list.php">শিক্ষক</a>
        <a href="/school_management/public/fees/fee_collection.php">ফি সংগ্রহ</a>
        <a href="/school_management/public/subjects/subjects_list.php">বিষয়সমূহ</a>
        <a href="/school_management/public/exam_results/add_exam_result.php">পরীক্ষা</a>
        <a href="/school_management/public/attendance/record_attendance.php">উপস্থিতি</a>
        <a href="/school_management/public/change_password.php">পাসওয়ার্ড পরিবর্তন</a>
        <a href="/school_management/public/logout.php">লগআউট</a>
    </div>
</div>
<div class="content">
    <div class="form-container">
        <h2>ফলাফল সম্পাদনা</h2>
        <?php if ($message): ?>
            <p class="message-success"><?php echo $message; ?></p>
        <?php endif; ?>
        <?php if ($error): ?>
            <p class="message-error"><?php echo $error; ?></p>
        <?php endif; ?>

        <form action="edit_exam_result.php?id=<?php echo htmlspecialchars($result_id); ?>" method="POST">
            <div class="form-group">
                <label for="class_id">শ্রেণি:</label>
                <select id="class_id" name="class_id" disabled>
                    <?php while($row = $classes_result->fetch_assoc()): ?>
                        <option value="<?php echo htmlspecialchars($row['class_id']); ?>" <?php echo ($row['class_id'] == $result_data['class_id']) ? 'selected' : ''; ?>>
                            <?php echo htmlspecialchars($row['class_name']); ?>
                        </option>
                    <?php endwhile; ?>
                </select>
            </div>
            
            <div class="form-group">
                <label for="student_id">শিক্ষার্থীর নাম:</label>
                <select id="student_id" name="student_id" required disabled>
                    <?php while($row = $students_result->fetch_assoc()): ?>
                        <option value="<?php echo htmlspecialchars($row['student_id']); ?>" <?php echo ($row['student_id'] == $result_data['student_id']) ? 'selected' : ''; ?>>
                            <?php echo htmlspecialchars($row['student_name']); ?>
                        </option>
                    <?php endwhile; ?>
                </select>
            </div>
            
            <div class="form-group">
                <label for="subject_id">বিষয়:</label>
                <select id="subject_id" name="subject_id" required>
                    <?php while($row = $subjects_result->fetch_assoc()): ?>
                        <option value="<?php echo htmlspecialchars($row['subject_id']); ?>" <?php echo ($row['subject_id'] == $result_data['subject_id']) ? 'selected' : ''; ?>>
                            <?php echo htmlspecialchars($row['subject_name']); ?>
                        </option>
                    <?php endwhile; ?>
                </select>
            </div>

            <div class="form-group">
                <label for="exam_id">পরীক্ষার ধরন:</label>
                <select id="exam_id" name="exam_id" required>
                    <?php while($row = $exams_result->fetch_assoc()): ?>
                        <option value="<?php echo htmlspecialchars($row['exam_id']); ?>" <?php echo ($row['exam_id'] == $result_data['exam_id']) ? 'selected' : ''; ?>>
                            <?php echo htmlspecialchars($row['exam_name']); ?>
                        </option>
                    <?php endwhile; ?>
                </select>
            </div>

            <div class="form-group">
                <label for="marks">প্রাপ্ত নম্বর:</label>
                <input type="number" step="0.01" id="marks" name="marks" value="<?php echo htmlspecialchars($result_data['marks']); ?>" required>
            </div>
            
            <div class="form-buttons">
                <button type="submit">আপডেট করুন</button>
                <a href="exam_report.php" class="button">ফলাফল রিপোর্ট</a>
            </div>
        </form>
    </div>
</div>
<div class="footer">
    <p>&copy; <?php echo date("Y"); ?> স্কুল ম্যানেজমেন্ট সিস্টেম। সর্বস্বত্ব সংরক্ষিত।</p>
</div>
</body>
</html>