<?php
session_start();
include '../../includes/db_connection.php';

if (!isset($_SESSION['user_id']) || ($_SESSION['role'] !== 'Admin' && $_SESSION['role'] !== 'Teacher')) {
    die("You do not have permission to perform this action.");
}

$result_id = isset($_GET['id']) ? $_GET['id'] : null;

if ($result_id) {
    $sql = "DELETE FROM exam_results WHERE result_id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $result_id);

    if ($stmt->execute()) {
        header("Location: add_exam_result.php");
        exit();
    } else {
        echo "Error: " . $stmt->error;
    }
    $stmt->close();
} else {
    echo "No exam result ID provided.";
}

$conn->close();
?>