<?php
session_start();
// ১. নিরাপত্তা যাচাই
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'Admin') {
    header("Location: /school_management/public/index.php");
    exit("অনুমতি নেই!");
}

// ২. ডাটাবেস সংযোগ তথ্য (আপনার db_connection.php ফাইল অনুযায়ী)
// আমরা এখানে সরাসরি ডাটাবেস তথ্য ব্যবহার করব কারণ db_connection.php এ সব তথ্য নাও থাকতে পারে।
// আপনার সংযোগ ফাইল থেকে এই মানগুলি নিশ্চিত করুন:
$db_host = "localhost"; // অথবা আপনার ডাটাবেস হোস্ট
$db_user = "root";      // আপনার ডাটাবেস ইউজারনেম
$db_pass = "";          // আপনার ডাটাবেস পাসওয়ার্ড (XAMPP-এ সাধারণত ফাঁকা)
$db_name = "school_db"; // আপনার ডাটাবেসের সঠিক নাম

// ৩. ফাইল নাম এবং সেভ পাথ নির্ধারণ
$date = date("Y-m-d_H-i-s");
$backup_file_name = $db_name . "_backup_" . $date . ".sql";
$backup_path = "C:\\xampp\\tmp\\" . $backup_file_name; // XAMPP এর একটি অস্থায়ী ফোল্ডার ব্যবহার করা হলো

// ৪. mysqldump কমান্ড তৈরি
// উইন্ডোজের জন্য XAMPP-এর ডিফল্ট পাথ ব্যবহার করা হলো
$mysqldump_path = "C:\\xampp\\mysql\\bin\\mysqldump";

// কমান্ডের পুরো স্ট্রিং
$command = "{$mysqldump_path} --host={$db_host} --user={$db_user} --password={$db_pass} {$db_name} > \"{$backup_path}\" 2>&1";

// ৫. কমান্ড কার্যকর করা
exec($command, $output, $return_var);

// ৬. ফলাফল প্রক্রিয়া এবং ফাইল ডাউনলোড
if ($return_var === 0) {
    // ফাইল ডাউনলোড শুরু
    if (file_exists($backup_path)) {
        header('Content-Type: application/octet-stream');
        header("Content-Transfer-Encoding: Binary");
        header("Content-disposition: attachment; filename=\"{$backup_file_name}\"");
        
        // ফাইল ডাউনলোডের পরে মুছে ফেলার ব্যবস্থা
        readfile($backup_path);
        unlink($backup_path); 
        exit();
    } else {
        echo "<p style='color:red;'>ব্যাকআপ ফাইলটি তৈরি হলেও ডাউনলোড করতে ব্যর্থ হয়েছে। ফাইলের পাথ: {$backup_path}</p>";
    }
} else {
    // ত্রুটি হলে আউটপুট দেখানো
    echo "<h2>ডাটাবেস ব্যাকআপ ব্যর্থ!</h2>";
    echo "<p style='color:red;'>কমান্ড কার্যকর করার সময় সমস্যা হয়েছে। নিচে ডিটেইলস দেখুন:</p>";
    echo "<pre>";
    print_r($output);
    echo "</pre>";
    echo "<p>সম্ভাব্য কারণ: mysqldump এর পাথ ভুল, অথবা ডাটাবেস ক্রেডেনশিয়ালস ভুল।</p>";
}
?>